/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.print;

import de.uka.ipd.sdq.probfunction.BoxedPDF;
import de.uka.ipd.sdq.probfunction.ContinuousSample;
import de.uka.ipd.sdq.probfunction.ExponentialDistribution;
import de.uka.ipd.sdq.probfunction.GammaDistribution;
import de.uka.ipd.sdq.probfunction.LognormalDistribution;
import de.uka.ipd.sdq.probfunction.NormalDistribution;
import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.Sample;
import de.uka.ipd.sdq.probfunction.util.ProbfunctionSwitch;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class ProbFunctionPrettyPrint
extends ProbfunctionSwitch<String> {
    @Override
    public String caseBoxedPDF(BoxedPDF object) {
        String sampleString = "";
        for (ContinuousSample s : object.getSamples()) {
            double value = s.getProbability();
            double precision = 1.0E-8;
            long temp = Math.round(value *= 1.0 / precision);
            double prob = (double)temp * precision;
            DecimalFormat df = new DecimalFormat("0.00000000", new DecimalFormatSymbols(Locale.US));
            sampleString = String.valueOf(sampleString) + " (" + s.getValue() + "; " + df.format(prob) + ")";
        }
        return "DoublePDF[" + sampleString + " ]";
    }

    @Override
    public String caseProbabilityMassFunction(ProbabilityMassFunction object) {
        Sample sample = (Sample)object.getSamples().get(0);
        String pmfType = this.detectType(sample);
        String sampleString = "";
        String leftSeparator = "";
        String rightSeparator = ";";
        if (pmfType.equals("EnumPMF")) {
            leftSeparator = "\"";
            rightSeparator = "\";";
        }
        for (Sample s : object.getSamples()) {
            sampleString = String.valueOf(sampleString) + " (" + leftSeparator + s.getValue() + rightSeparator + s.getProbability() + ")";
        }
        return String.valueOf(pmfType) + "[" + sampleString + " ]";
    }

    @Override
    public String caseExponentialDistribution(ExponentialDistribution object) {
        return "Exp(" + object.getRate() + ")";
    }

    @Override
    public String caseGammaDistribution(GammaDistribution object) {
        return "Gamma(" + object.getAlpha() + ", " + object.getTheta() + ")";
    }

    @Override
    public String caseLognormalDistribution(LognormalDistribution object) {
        return "Lognorm(" + object.getMu() + ", " + object.getSigma() + ")";
    }

    @Override
    public String caseNormalDistribution(NormalDistribution object) {
        return "Norm(" + object.getMu() + ", " + object.getSigma() + ")";
    }

    private String detectType(Sample object) {
        if (object.getValue() instanceof Integer) {
            return "IntPMF";
        }
        if (object.getValue() instanceof Double) {
            return "DoublePMF";
        }
        if (object.getValue().equals("true") || object.getValue().equals("false") || object.getValue() instanceof Boolean) {
            return "BoolPMF";
        }
        if (object.getValue() instanceof String) {
            return "EnumPMF";
        }
        throw new UnsupportedOperationException("Unknown PMF found!");
    }
}

