/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.dialogs;

import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.CSVDirectoryDialog;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.DialogType;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.Separator;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CSVSettingsDialog
extends Dialog {
    protected Object result;
    protected Shell frmDialog;
    private String fileOrDirName = "";
    private String pathFileOrDir = "";
    private String pathParentDir = "";
    private Button btnSave;
    private Button chkHeader;
    private boolean isHeader = true;
    private boolean isSettingsDialogCanceled = false;
    private boolean isFileOrDirDialogCanceled = false;
    private Combo cmbSeparator;
    private String selectedSeparator = Separator.Semicolon.toString();
    private String[] separatorItems;
    private Label lblHeader;
    private String fileExtension = "";
    private DialogType dialogType;

    public CSVSettingsDialog(String pathParentDir, String fileOrDirName, String fileExtension, DialogType type) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 67680);
        this.setText("SWT Dialog");
        this.dialogType = type;
        this.pathParentDir = pathParentDir;
        this.fileOrDirName = fileOrDirName;
        this.fileExtension = fileExtension;
        this.separatorItems = new String[3];
        int i = 0;
        Separator[] separatorArray = Separator.values();
        int n = separatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Separator sep = separatorArray[n2];
            this.separatorItems[i] = sep.toString();
            ++i;
            ++n2;
        }
    }

    public Object open() {
        this.createContents();
        this.frmDialog.open();
        this.frmDialog.layout();
        Display display = this.getParent().getDisplay();
        while (!this.frmDialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    public boolean getValidPath() {
        String pathDir = "";
        while (!this.isSettingsDialogCanceled & this.getPath().equals("")) {
            this.isFileOrDirDialogCanceled = false;
            this.isSettingsDialogCanceled = false;
            this.open();
            if (!this.isPathValid()) continue;
            if (this.dialogType != DialogType.DIRECTORY) continue;
            pathDir = String.valueOf(this.getPath()) + File.separatorChar + this.fileOrDirName;
            this.createDirectory(pathDir);
        }
        if (this.dialogType == DialogType.DIRECTORY) {
            this.pathFileOrDir = pathDir;
        }
        this.dispose();
        return this.isPathValid();
    }

    private void createDirectory(String pathDir) {
        File fileObject = new File(pathDir);
        if (fileObject.exists()) {
            MessageBox box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 288);
            box.setMessage("The directory already exists! Do you want to overwrite it?");
            int boxResult = box.open();
            if (boxResult == 32) {
                this.deleteTree(fileObject);
                fileObject.mkdirs();
            } else if (boxResult == 256) {
                this.pathFileOrDir = "";
            }
        } else {
            fileObject.mkdirs();
        }
    }

    private void deleteTree(File path) {
        File[] fileArray = path.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.deleteTree(file);
            } else {
                file.delete();
            }
            ++n2;
        }
        path.delete();
    }

    private void createContents() {
        this.frmDialog = new Shell(this.getParent(), 2144);
        this.frmDialog.setMinimumSize(new Point(100, 100));
        this.frmDialog.setSize(245, 220);
        this.frmDialog.setText("CSV Settings");
        this.frmDialog.setLocation(300, 300);
        Group grpSeparator = new Group((Composite)this.frmDialog, 0);
        grpSeparator.setBounds(10, 31, 218, 90);
        this.cmbSeparator = new Combo((Composite)grpSeparator, 0);
        this.cmbSeparator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSVSettingsDialog.this.selectedSeparator = CSVSettingsDialog.this.cmbSeparator.getItem(CSVSettingsDialog.this.cmbSeparator.getSelectionIndex());
            }
        });
        this.cmbSeparator.setBounds(10, 20, 105, 23);
        this.cmbSeparator.setItems(this.separatorItems);
        this.cmbSeparator.select(0);
        Label lblSeparator = new Label((Composite)grpSeparator, 0);
        lblSeparator.setBounds(143, 23, 65, 20);
        lblSeparator.setText("Separator");
        this.chkHeader = new Button((Composite)grpSeparator, 32);
        this.chkHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSVSettingsDialog.this.isHeader = CSVSettingsDialog.this.chkHeader.getSelection();
            }
        });
        this.chkHeader.setBounds(56, 61, 51, 23);
        this.chkHeader.setSelection(this.isHeader);
        this.lblHeader = new Label((Composite)grpSeparator, 0);
        this.lblHeader.setBounds(143, 64, 65, 20);
        this.lblHeader.setText("Header");
        this.btnSave = new Button((Composite)this.frmDialog, 0);
        this.btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CSVSettingsDialog.this.dialogType == DialogType.FILE) {
                    CSVSettingsDialog.this.saveAsCSVFileDialog();
                } else if (CSVSettingsDialog.this.dialogType == DialogType.DIRECTORY) {
                    CSVDirectoryDialog dirDialog = new CSVDirectoryDialog(CSVSettingsDialog.this.pathParentDir);
                    CSVSettingsDialog.this.pathParentDir = dirDialog.getPathDir();
                    CSVSettingsDialog.this.pathFileOrDir = CSVSettingsDialog.this.pathParentDir;
                    CSVSettingsDialog.this.isFileOrDirDialogCanceled = dirDialog.isCanceled();
                }
                CSVSettingsDialog.this.frmDialog.close();
            }
        });
        this.btnSave.setBounds(10, 152, 75, 25);
        this.btnSave.setText("Save As");
        Button btnCancel = new Button((Composite)this.frmDialog, 0);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSVSettingsDialog.this.pathFileOrDir = "";
                CSVSettingsDialog.this.frmDialog.close();
                CSVSettingsDialog.this.isSettingsDialogCanceled = true;
            }
        });
        btnCancel.setBounds(153, 152, 75, 25);
        btnCancel.setText("Cancel");
    }

    private void saveAsCSVFileDialog() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.setFilterPath(this.pathParentDir);
        dialog.setFileName(this.fileOrDirName);
        dialog.setFilterExtensions(new String[]{this.fileExtension});
        dialog.setOverwrite(true);
        this.pathFileOrDir = dialog.open();
        if (this.pathFileOrDir == null) {
            this.pathFileOrDir = "";
            this.isFileOrDirDialogCanceled = true;
        }
    }

    public String getPath() {
        return this.pathFileOrDir;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public String getSeparator() {
        if (this.selectedSeparator.equals(Separator.Semicolon.toString())) {
            return ";";
        }
        if (this.selectedSeparator.equals(Separator.Comma.toString())) {
            return ",";
        }
        if (this.selectedSeparator.equals(Separator.Tabulator.toString())) {
            return "\t";
        }
        return ";";
    }

    public void dispose() {
        this.frmDialog.dispose();
    }

    public boolean isPathValid() {
        return !(this.getPath().equals("") | this.isFileOrDirDialogCanceled | this.isSettingsDialogCanceled);
    }
}

