/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.dialogs;

import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.SensorsDialogCellModifier;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.SensorsDialogContentProvider;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.SensorsDialogLabelProvider;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEntry;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SensorsDialog
extends TitleAreaDialog {
    private ConfigEntry entry;
    public static final int CHECK_COLUMN_INDEX = 0;
    public static final int SENSOR_ID_INDEX = 1;
    public static final int SENSOR_NAME_COLUMN_INDEX = 2;
    public static final String CHECK_COLUMN = "";
    public static final String SENSOR_ID_COLUMN = "Id";
    public static final String SENSOR_NAME_COLUMN = "Sensorname";
    public static String[] columnNames = new String[]{"", "Id", "Sensorname"};
    private Table table;

    public SensorsDialog(Shell parentShell, ConfigEntry entry) {
        super(parentShell);
        this.entry = entry;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        final TableViewer tableViewer = new TableViewer(container, 2048);
        this.table = tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn checkColumn = new TableColumn(this.table, 16384);
        checkColumn.setWidth(24);
        checkColumn.setText(CHECK_COLUMN);
        TableColumn experimentColumn = new TableColumn(this.table, 16384);
        experimentColumn.setWidth(40);
        experimentColumn.setText(SENSOR_ID_COLUMN);
        TableColumn sensorColumn = new TableColumn(this.table, 16384);
        sensorColumn.setWidth(260);
        sensorColumn.setText(SENSOR_NAME_COLUMN);
        CellEditor[] editors = new CellEditor[columnNames.length];
        editors[0] = new CheckboxCellEditor((Composite)this.table);
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                tableViewer.refresh();
            }
        });
        tableViewer.setColumnProperties(columnNames);
        tableViewer.setCellEditors(editors);
        tableViewer.setCellModifier((ICellModifier)new SensorsDialogCellModifier(this.entry));
        tableViewer.setContentProvider((IContentProvider)new SensorsDialogContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new SensorsDialogLabelProvider(this.entry));
        tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof Sensor && e2 instanceof Sensor) {
                    return ((Sensor)e1).getSensorName().compareToIgnoreCase(((Sensor)e2).getSensorName());
                }
                throw new IllegalArgumentException("Not comparable: " + e1 + " " + e2);
            }
        });
        tableViewer.setInput((Object)this.entry);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(400, 350);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select sensors");
    }
}

