/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.editor;

import de.uka.ipd.sdq.sensorframework.adapter.AdapterRegistry;
import de.uka.ipd.sdq.sensorframework.adapter.DataAdapter;
import de.uka.ipd.sdq.sensorframework.adapter.IAdapterFactory;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEditorInput;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEntry;
import de.uka.ipd.sdq.sensorframework.visualisation.views.ViewDropTargetListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractReportView
extends EditorPart
implements ITabbedPropertySheetPageContributor,
Observer {
    public static String ABSTRACT_EDITOR_ID = "de.uka.ipd.sdq.sensorframework.visualisation.AbstractReportView";
    protected ConfigEditorInput myInput;
    private ArrayList<DataAdapter> dataAdapters = null;
    private boolean ignoreDataSettingsChanged = false;

    public void createPartControl(Composite parent) {
        this.getSite().setSelectionProvider(new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return new StructuredSelection((Object)this);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        });
        this.addDropSupport((Control)parent);
        this.createReportControls(parent);
        this.changedInputData();
    }

    protected abstract void createReportControls(Composite var1);

    private void addDropSupport(Control control) {
        int operations = 17;
        DropTarget target = new DropTarget(control, operations);
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        target.setTransfer(transferTypes);
        target.addDropListener((DropTargetListener)new ViewDropTargetListener(this.getEditorInput()));
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return ABSTRACT_EDITOR_ID;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.myInput = (ConfigEditorInput)input;
        this.myInput.addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.getSite().getPage().activate((IWorkbenchPart)this);
        if (arg != null) {
            if (arg == "Settings have changed" && !this.ignoreDataSettingsChanged) {
                this.generateVisualization(this.dataAdapters);
            }
            if (ConfigEditorInput.class.isInstance(arg)) {
                this.changedInputData();
            }
        }
    }

    private void changedInputData() {
        ArrayList<SensorAndMeasurements> list = new ArrayList<SensorAndMeasurements>();
        for (ConfigEntry re : this.myInput.getConfigEntrys()) {
            for (Sensor s : re.getSensors()) {
                try {
                    list.add(re.getExperimentRun().getMeasurementsOfSensor(s));
                }
                catch (Exception e1) {
                    this.showMessage(s.getSensorName(), "Missing the Measurements of sensor!");
                }
            }
        }
        IAdapterFactory adapterFactory = AdapterRegistry.singleton().getFactoryByID(this.myInput.getAdapterFactoryID());
        ArrayList<DataAdapter> newDataAdapters = new ArrayList<DataAdapter>();
        DataAdapter usedAdapter = null;
        for (SensorAndMeasurements sam : list) {
            usedAdapter = adapterFactory.getAdapter(this.myInput.getFiltersManager().getFilteredMeasurements(sam));
            usedAdapter.addObserver((Observer)this);
            newDataAdapters.add(usedAdapter);
        }
        this.generateVisualization(newDataAdapters);
        for (DataAdapter adapter : newDataAdapters) {
            adapter.addObserver((Observer)this);
        }
        this.dataAdapters = newDataAdapters;
    }

    protected abstract void generateVisualization(List<DataAdapter> var1);

    private void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.getEditorSite().getShell(), (String)title, (String)message);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isIgnoreDataSettingsChanged() {
        return this.ignoreDataSettingsChanged;
    }

    public void setIgnoreDataSettingsChanged(boolean ignoreDataSettingsChanged) {
        this.ignoreDataSettingsChanged = ignoreDataSettingsChanged;
    }
}

