/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.editor;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEditorInput;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.ConfigEntry;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class ConfigEditorInputFactory
implements IElementFactory {
    private static final String ID_FACTORY = "de.uka.ipd.sdq.sensorframework.visualisation.configEditorInputFactory";
    private static final String DATASOURCE = "Datasource";
    private static final String EXPERIMENT = "Experiment";
    private static final String EXPERIMENT_RUN = "ExperimentRun";
    private static final String SENSOR_NAME = "SensorName";
    private static final String SENSOR_ID = "SensorId";
    private static final String ADAPTER_FACTORY_ID_ID = "AdpaterFactoryIDID";

    public IAdaptable createElement(IMemento memento) {
        ConfigEntry configEntry = null;
        try {
            configEntry = new ConfigEntry(this.getDatasource(memento), this.getExperimentRun(memento), this.getExperiment(memento), this.getSensor(memento));
        }
        catch (Exception e) {
            return null;
        }
        return new ConfigEditorInput(this.getAdapterFactoryID(memento), configEntry);
    }

    private String getAdapterFactoryID(IMemento memento) {
        return memento.getString(ADAPTER_FACTORY_ID_ID);
    }

    public static String getFactoryId() {
        return ID_FACTORY;
    }

    public static void saveState(IMemento memento, ConfigEditorInput input) {
        for (ConfigEntry entry : input.getConfigEntrys()) {
            memento.putString(DATASOURCE, Long.toString(entry.getDatasource().getID()));
            memento.putString(EXPERIMENT, Long.toString(entry.getExperiment().getExperimentID()));
            memento.putString(EXPERIMENT_RUN, Long.toString(entry.getExperimentRun().getExperimentRunID()));
            for (Sensor sensor : entry.getSensors()) {
                memento.putString(SENSOR_NAME, sensor.getSensorName());
                memento.putString(SENSOR_ID, String.valueOf(sensor.getSensorID()));
            }
        }
        memento.putString(ADAPTER_FACTORY_ID_ID, input.getAdapterFactoryID());
    }

    private Sensor getSensor(IMemento memento) {
        String sensorId = memento.getString(SENSOR_ID);
        if (sensorId == null) {
            return null;
        }
        IDAOFactory data = this.getDatasource(memento);
        return data.createSensorDAO().get(Long.parseLong(sensorId));
    }

    private ExperimentRun getExperimentRun(IMemento memento) {
        String experimentRun = memento.getString(EXPERIMENT_RUN);
        if (experimentRun == null) {
            return null;
        }
        IDAOFactory data = this.getDatasource(memento);
        return data.createExperimentRunDAO().get(Long.parseLong(experimentRun));
    }

    private IDAOFactory getDatasource(IMemento memento) {
        String datasource = memento.getString(DATASOURCE);
        if (datasource == null) {
            return null;
        }
        IDAOFactory data = SensorFrameworkDataset.singleton().getDataSourceByID(Long.parseLong(datasource));
        return data;
    }

    private Experiment getExperiment(IMemento memento) {
        String experiment = memento.getString(EXPERIMENT);
        if (experiment == null) {
            return null;
        }
        IDAOFactory data = this.getDatasource(memento);
        return data.createExperimentDAO().get(Long.parseLong(experiment));
    }
}

