/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.views;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.AddNewDatasourceWizard;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.ConfigureDatasourceDialog;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.OpenDatasourceWizard;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.StateMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanMeasurement;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.visualisation.VisualisationPlugin;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.CSVSettingsDialog;
import de.uka.ipd.sdq.sensorframework.visualisation.dialogs.DialogType;
import de.uka.ipd.sdq.sensorframework.visualisation.views.DAOFactoryPreferencePage;
import de.uka.ipd.sdq.sensorframework.visualisation.views.DoubleClickListener;
import de.uka.ipd.sdq.sensorframework.visualisation.views.ExperimentAndDAO;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeContainer;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeContentProvider;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeDragSourceListener;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeLabelProvider;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.ViewPart;

public class ExperimentsView
extends ViewPart {
    private TreeViewer viewer;
    private IDAOFactory selectedFactory = null;
    private Experiment selectedExperiment = null;
    private Action reloadView;
    private Action saveAsCSV;
    private Action collapseAll;
    private Action expandAll;
    private Action newDataSet;
    private Action openDataSet;
    private Action deleteDataSet;
    private Action properties;
    private static Logger logger = Logger.getLogger("de.uka.ipd.sdq.sensorframework.visualisation.views.ExperimentsView.log");

    public void createPartControl(Composite parent) {
        int ops = 3;
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        Transfer[] transfers = new Transfer[]{EditorInputTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
        this.viewer.addDragSupport(ops, transfers, (DragSourceListener)new TreeDragSourceListener(this.viewer));
        this.viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selectedObject = selection.getFirstElement();
                ExperimentsView.this.setSelectedElement(selectedObject);
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExperimentsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.newDataSet);
        manager.add((IAction)this.openDataSet);
        manager.add((IAction)this.deleteDataSet);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.reloadView);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.deleteDataSet);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.reloadView);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.properties);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.saveAsCSV);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.newDataSet);
        manager.add((IAction)this.openDataSet);
        manager.add((IAction)this.deleteDataSet);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.reloadView);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.collapseAll);
        manager.add((IAction)this.expandAll);
        manager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.reloadView = new Action(){

            public void run() {
                try {
                    SensorFrameworkDataset.singleton().reload();
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Reloading the Sensor Dataset Failed", (String)("Reloading the Sensor Dataset Failed. Error Message given: " + ex.getMessage()));
                }
                ExperimentsView.this.viewer.refresh();
            }
        };
        this.reloadView.setText("Reload View");
        this.reloadView.setToolTipText("Reload View");
        this.reloadView.setImageDescriptor(VisualisationPlugin.getImageDescriptor("/icons/db_reload_obj.gif"));
        this.collapseAll = new Action(){

            public void run() {
                ExperimentsView.this.viewer.collapseAll();
            }
        };
        this.collapseAll.setText("Collapse All");
        this.collapseAll.setToolTipText("Collapse All");
        this.collapseAll.setImageDescriptor(VisualisationPlugin.getImageDescriptor("/icons/collapseall.gif"));
        this.expandAll = new Action(){

            public void run() {
                ExperimentsView.this.viewer.expandAll();
            }
        };
        this.expandAll.setText("Expand All");
        this.expandAll.setToolTipText("Expand All");
        this.expandAll.setImageDescriptor(VisualisationPlugin.getImageDescriptor("/icons/expandall.gif"));
        this.newDataSet = new Action(){

            public void run() {
                AddNewDatasourceWizard wizard = new AddNewDatasourceWizard();
                WizardDialog dialog = new WizardDialog(ExperimentsView.this.getSite().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.setTitle(ConfigureDatasourceDialog.ADD_WIZARD_TITLE);
                dialog.open();
                ExperimentsView.this.viewer.refresh();
            }
        };
        this.newDataSet.setText("New Data Source");
        this.newDataSet.setToolTipText("New Data Source");
        this.newDataSet.setImageDescriptor(VisualisationPlugin.getImageDescriptor("/icons/add_obj.gif"));
        this.openDataSet = new Action(){

            public void run() {
                OpenDatasourceWizard wizard = new OpenDatasourceWizard();
                WizardDialog dialog = new WizardDialog(ExperimentsView.this.getSite().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.setTitle(ConfigureDatasourceDialog.OPEN_WISARD_TITLE);
                dialog.open();
                ExperimentsView.this.viewer.refresh();
            }
        };
        this.openDataSet.setText("Open");
        this.openDataSet.setToolTipText("Open a Data Source");
        this.openDataSet.setImageDescriptor(VisualisationPlugin.getImageDescriptor("/icons/data_source_folder.gif"));
        this.deleteDataSet = new Action(){

            public void run() {
                if (ExperimentsView.this.selectedFactory != null) {
                    SensorFrameworkDataset.singleton().removeDataSource(ExperimentsView.this.selectedFactory);
                    ExperimentsView.this.viewer.refresh();
                }
                if (ExperimentsView.this.selectedExperiment != null && ExperimentsView.this.selectedFactory != null) {
                    ExperimentsView.this.selectedFactory.createExperimentDAO().removeExperiment(ExperimentsView.this.selectedExperiment, true);
                    ExperimentsView.this.viewer.refresh();
                }
            }
        };
        this.deleteDataSet.setText("Delete");
        this.deleteDataSet.setToolTipText("Delete a Data Source/Experiment");
        this.deleteDataSet.setImageDescriptor(VisualisationPlugin.getImageDescriptor("/icons/remove_obj.gif"));
        this.deleteDataSet.setEnabled(false);
        this.properties = new Action(){

            public void run() {
                DAOFactoryPreferencePage page = new DAOFactoryPreferencePage(ExperimentsView.this.selectedFactory);
                page.setTitle("General Information");
                PreferenceManager mgr = new PreferenceManager();
                PreferenceNode node = new PreferenceNode("1", (IPreferencePage)page);
                mgr.addToRoot((IPreferenceNode)node);
                PreferenceDialog dialog = new PreferenceDialog(ExperimentsView.this.getSite().getShell(), mgr);
                dialog.create();
                dialog.setMessage(page.getTitle());
                dialog.open();
            }
        };
        this.properties.setText("Properties");
        this.properties.setEnabled(false);
        this.saveAsCSV = new Action(){

            public void run() {
                ExperimentsView.this.exportSelectedDataToCSV();
            }
        };
        this.saveAsCSV.setText("Save as CSV");
    }

    private void exportSensorMeasurementToCSV(String fileName, Collection<Measurement> measurement, boolean isHeader, String separator) {
        try {
            FileWriter fileWriter = new FileWriter(fileName);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            if (measurement.iterator().next() instanceof StateMeasurement) {
                if (isHeader) {
                    bufferedWriter.append("Event Time" + separator + "State" + "\n");
                }
                for (StateMeasurement stateMeasurement : measurement) {
                    bufferedWriter.append(String.valueOf(stateMeasurement.getEventTime()) + separator + stateMeasurement.getSensorState().getStateLiteral() + "\n");
                }
            } else if (measurement.iterator().next() instanceof TimeSpanMeasurement) {
                if (isHeader) {
                    bufferedWriter.append("Event Time" + separator + "Time Span" + "\n");
                }
                for (TimeSpanMeasurement timeSpanMeasurement : measurement) {
                    bufferedWriter.append(String.valueOf(timeSpanMeasurement.getEventTime()) + separator + timeSpanMeasurement.getTimeSpan() + "\n");
                }
            } else {
                logger.log(Level.SEVERE, "It is not possible to export this type of measurement to the CSV format. At the moment only instances of StateMeasurement and TimeSpanMeasurement are suitable.");
                throw new IllegalArgumentException();
            }
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exportExperimentRunToCSV(String pathDir, Collection<Sensor> sensors, ExperimentRun run, boolean isHeader, String separator) {
        for (Sensor sensor : sensors) {
            SensorAndMeasurements sensorAndMeasurements = run.getMeasurementsOfSensor(sensor);
            String fileName = this.sanitizeFileName(String.valueOf(sensor.getSensorName().toString()) + ".csv");
            String pathFile = String.valueOf(pathDir) + File.separatorChar + fileName;
            this.exportSensorMeasurementToCSV(pathFile, sensorAndMeasurements.getMeasurements(), isHeader, separator);
        }
    }

    private void exportSelectedDataToCSV() {
        ISelection selection = this.viewer.getSelection();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object object = structuredSelection.getFirstElement();
        if (!(object instanceof FileDAOFactory) && !(object instanceof ExperimentAndDAO)) {
            if (object instanceof TreeContainer) {
                TreeContainer treeContainer = (TreeContainer)object;
                String dirAllExperimentRuns = treeContainer.getName();
                CSVSettingsDialog dialog = new CSVSettingsDialog("", dirAllExperimentRuns, "", DialogType.DIRECTORY);
                if (dialog.getValidPath()) {
                    this.exportAllExperimentRunsToCSV(dialog.getPath(), treeContainer.getElements(), dialog.isHeader(), dialog.getSeparator());
                }
            } else if (object instanceof TreeObject) {
                ExperimentRun run;
                String dirExperiment;
                CSVSettingsDialog dialog;
                TreeObject treeObject = (TreeObject)object;
                Object innerObject = treeObject.getObject();
                if (innerObject instanceof Sensor) {
                    Sensor sensor = (Sensor)innerObject;
                    SensorAndMeasurements sensorAndMeasurements = treeObject.getRun().getMeasurementsOfSensor(sensor);
                    String fileName = this.sanitizeFileName(String.valueOf(sensorAndMeasurements.getSensor().getSensorName().toString()) + ".csv");
                    CSVSettingsDialog dialog2 = new CSVSettingsDialog("", fileName, "*.csv", DialogType.FILE);
                    if (dialog2.getValidPath()) {
                        this.exportSensorMeasurementToCSV(dialog2.getPath(), sensorAndMeasurements.getMeasurements(), dialog2.isHeader(), dialog2.getSeparator());
                    }
                } else if (innerObject instanceof ExperimentRun && (dialog = new CSVSettingsDialog("", dirExperiment = this.sanitizeFileName((run = (ExperimentRun)innerObject).getExperimentDateTime()), "", DialogType.DIRECTORY)).getValidPath()) {
                    this.exportExperimentRunToCSV(dialog.getPath(), treeObject.getExperiment().getSensors(), run, dialog.isHeader(), dialog.getSeparator());
                }
            }
        }
    }

    private void exportAllExperimentRunsToCSV(String pathDir, Collection<TreeObject> allExperimentRuns, boolean isHeader, String separator) {
        for (TreeObject treeObject : allExperimentRuns) {
            Object innerObject = treeObject.getObject();
            if (!(innerObject instanceof ExperimentRun)) continue;
            ExperimentRun run = (ExperimentRun)innerObject;
            String dirExperiment = this.sanitizeFileName(run.getExperimentDateTime());
            String pathAllExperimentRuns = String.valueOf(pathDir) + File.separatorChar + dirExperiment;
            new File(pathAllExperimentRuns).mkdirs();
            this.exportExperimentRunToCSV(pathAllExperimentRuns, treeObject.getExperiment().getSensors(), run, isHeader, separator);
        }
    }

    private String sanitizeFileName(String fileOrDirName) {
        fileOrDirName = fileOrDirName.replace('\\', '-');
        fileOrDirName = fileOrDirName.replace('/', '-');
        fileOrDirName = fileOrDirName.replace(':', '-');
        fileOrDirName = fileOrDirName.replace('*', '+');
        fileOrDirName = fileOrDirName.replace('?', '!');
        fileOrDirName = fileOrDirName.replace('\"', ' ');
        fileOrDirName = fileOrDirName.replace('<', '(');
        fileOrDirName = fileOrDirName.replace('>', ')');
        fileOrDirName = fileOrDirName.replace('|', ',');
        return fileOrDirName;
    }

    private void setSelectedElement(Object selected) {
        this.selectedFactory = null;
        this.selectedExperiment = null;
        if (selected instanceof IDAOFactory) {
            this.selectedFactory = (IDAOFactory)selected;
            this.deleteDataSet.setEnabled(true);
            this.properties.setEnabled(true);
            this.saveAsCSV.setEnabled(false);
        } else if (selected instanceof ExperimentAndDAO) {
            ExperimentAndDAO experimentAndDAO = (ExperimentAndDAO)selected;
            this.selectedExperiment = experimentAndDAO.getExperiment();
            this.selectedFactory = experimentAndDAO.getDatasource();
            this.deleteDataSet.setEnabled(true);
            this.properties.setEnabled(false);
            this.saveAsCSV.setEnabled(false);
        } else {
            this.deleteDataSet.setEnabled(false);
            this.properties.setEnabled(false);
            this.saveAsCSV.setEnabled(true);
            if (selected instanceof TreeContainer) {
                if (((TreeContainer)selected).getName().equals("Sensors")) {
                    this.saveAsCSV.setEnabled(false);
                }
            } else if (selected instanceof TreeObject && !(((TreeObject)selected).getObject() instanceof ExperimentRun) && ((TreeObject)selected).getRun() == null) {
                this.saveAsCSV.setEnabled(false);
            }
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

