/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.views;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.visualisation.views.TreeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;

public class TreeContainer
implements IAdaptable {
    private Experiment experiment;
    private List<TreeObject> elements = null;
    private String name;
    private int type;
    private String EXPERIMENT_RUNS_NAME = "Experiment Runs";
    private String SENSORS_NAME = "Sensors";

    public TreeContainer(IDAOFactory datasource, Experiment experiment, int type) {
        this.experiment = experiment;
        this.type = type;
        this.elements = new ArrayList<TreeObject>();
        if (type == 0) {
            Collection runs = experiment.getExperimentRuns();
            for (ExperimentRun r : runs) {
                this.elements.add(new TreeObject(r, datasource, experiment));
            }
            this.name = this.EXPERIMENT_RUNS_NAME;
        }
        if (type == 1) {
            Collection sensors = experiment.getSensors();
            for (Sensor s : sensors) {
                this.elements.add(new TreeObject(s, datasource, experiment));
            }
            this.name = this.SENSORS_NAME;
        }
    }

    public List<TreeObject> getElements() {
        return this.elements;
    }

    public Experiment getParent() {
        return this.experiment;
    }

    public void setParent(Experiment parent) {
        this.experiment = parent;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }
}

