/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.ui.provider.categoryaware;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IItemProviderDecorator;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderDecorator;
import org.palladiosimulator.pcm.ui.provider.categoryaware.CategoryAwareItemProviderAdapterFactory;
import org.palladiosimulator.pcm.ui.provider.categoryaware.CategoryDescriptor;
import org.palladiosimulator.pcm.ui.provider.categoryaware.GenericCategoryItemProvider;
import org.palladiosimulator.pcm.ui.provider.categoryaware.ICategoryDescriptions;

public class CategoryAwareItemProvider
extends ItemProviderDecorator
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemProviderDecorator,
IDisposable {
    private ICategoryDescriptions categories;
    private HashMap<EObject, Collection> childCache = new HashMap();

    public void dispose() {
        Iterator<Collection> childCacheIterator = this.childCache.values().iterator();
        while (childCacheIterator.hasNext()) {
            Iterator itemProviderIterator = childCacheIterator.next().iterator();
            while (itemProviderIterator.hasNext()) {
                ((GenericCategoryItemProvider)((Object)itemProviderIterator.next())).dispose();
            }
        }
        super.dispose();
    }

    public CategoryAwareItemProvider(AdapterFactory adapterFactory, ICategoryDescriptions categories) {
        super(adapterFactory);
        this.categories = categories;
    }

    public CategoryAwareItemProvider(CategoryAwareItemProviderAdapterFactory factory, ICategoryDescriptions categories) {
        super((AdapterFactory)factory);
        this.categories = categories;
    }

    public Collection getChildren(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (this.categories.hasCategoriesForObject(eObject)) {
                if (!this.childCache.containsKey(eObject)) {
                    ArrayList<GenericCategoryItemProvider> children = new ArrayList<GenericCategoryItemProvider>();
                    Collection<CategoryDescriptor> childDescriptors = this.categories.getCategoriesForObject(eObject);
                    Iterator<CategoryDescriptor> iterator = childDescriptors.iterator();
                    while (iterator.hasNext()) {
                        children.add(new GenericCategoryItemProvider(this.adapterFactory, iterator.next(), eObject));
                    }
                    this.childCache.put(eObject, children);
                }
                return this.childCache.get(eObject);
            }
            return super.getChildren(object);
        }
        return super.getChildren(object);
    }
}

