/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.allocation.impl;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.impl.AllocationImplGen;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.subsystem.SubSystem;

public class AllocationImpl
extends AllocationImplGen {
    @Override
    public boolean validateEachAssemblyContextWithinSystemHasToBeAllocatedExactlyOnce(DiagnosticChain diagnostics, Map<Object, Object> context) {
        ValidationResult validationResult = this.validateEachAssemblyContextWithinSystemHasToBeAllocatedExactlyOnce();
        if (!validationResult.isValid() && diagnostics != null) {
            String defaultMessage = EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"eachAssemblyContextWithinSystemHasToBeAllocatedExactlyOnce", AllocationImpl.getEntityLabel(this)});
            String validationMessage = String.format("%s: %s", defaultMessage, validationResult.getMessage());
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.palladiosimulator.pcm.allocation", 1, validationMessage, new Object[]{this}));
        }
        return validationResult.isValid();
    }

    protected ValidationResult validateEachAssemblyContextWithinSystemHasToBeAllocatedExactlyOnce() {
        ValidationResult testResult = this.testAtMostOneAllocationForAssemblyContextExists();
        if (!testResult.isValid()) {
            return testResult;
        }
        Set<AssemblyContext> allocatedAssemblyContexts = this.getAllocatedAssemblyContexts();
        Set<AssemblyContext> unallocatedAssemblyContexts = this.findUnallocatedAssemblyContexts(allocatedAssemblyContexts);
        Set<SubSystem> remainingSubsystems = AllocationImpl.extractAllSubsystems(unallocatedAssemblyContexts);
        if (remainingSubsystems.size() != unallocatedAssemblyContexts.size()) {
            String assemblyContextMessagePart = unallocatedAssemblyContexts.stream().map(AllocationImpl::getEntityLabel).collect(Collectors.joining(", "));
            return new ValidationResult(String.format("There are unallocated %s elements: %s", AssemblyContext.class.getSimpleName(), assemblyContextMessagePart));
        }
        return AllocationImpl.testCorrectAllocationOfSubsystems(remainingSubsystems, allocatedAssemblyContexts);
    }

    protected ValidationResult testAtMostOneAllocationForAssemblyContextExists() {
        HashSet<AssemblyContext> allocatedAssemblyContexts = new HashSet<AssemblyContext>();
        for (AllocationContext allocation : this.getAllocationContexts_Allocation()) {
            if (allocatedAssemblyContexts.add(allocation.getAssemblyContext_AllocationContext())) continue;
            return new ValidationResult(String.format("%s %s allocates %s elements more than once.", Allocation.class.getSimpleName(), AllocationImpl.getEntityLabel(allocation), AssemblyContext.class.getSimpleName()));
        }
        return new ValidationResult();
    }

    protected Set<AssemblyContext> getAllocatedAssemblyContexts() {
        return this.getAllocationContexts_Allocation().stream().map(AllocationContext::getAssemblyContext_AllocationContext).collect(Collectors.toSet());
    }

    protected Set<AssemblyContext> findUnallocatedAssemblyContexts(Set<AssemblyContext> allocatedAssemblyContexts) {
        return this.getSystem_Allocation().getAssemblyContexts__ComposedStructure().stream().filter(ac -> !allocatedAssemblyContexts.contains(ac)).collect(Collectors.toSet());
    }

    protected static Set<SubSystem> extractAllSubsystems(Set<AssemblyContext> assemblyContexts) {
        return assemblyContexts.stream().map(AssemblyContext::getEncapsulatedComponent__AssemblyContext).filter(SubSystem.class::isInstance).map(SubSystem.class::cast).collect(Collectors.toSet());
    }

    protected static ValidationResult testCorrectAllocationOfSubsystems(Set<SubSystem> subsystems, Set<AssemblyContext> allocatedAssemblyContexts) {
        LinkedList<SubSystem> queue = new LinkedList<SubSystem>(subsystems);
        while (!queue.isEmpty()) {
            SubSystem subSystem = queue.pop();
            for (AssemblyContext ac : subSystem.getAssemblyContexts__ComposedStructure()) {
                if (allocatedAssemblyContexts.contains(ac)) continue;
                RepositoryComponent encapsulatedComponent = ac.getEncapsulatedComponent__AssemblyContext();
                if (!(encapsulatedComponent instanceof SubSystem)) {
                    return new ValidationResult(String.format("%s %s of %s %s is not allocated.", AssemblyContext.class.getSimpleName(), AllocationImpl.getEntityLabel(ac), SubSystem.class.getSimpleName(), AllocationImpl.getEntityLabel(subSystem)));
                }
                queue.add((SubSystem)encapsulatedComponent);
            }
        }
        return new ValidationResult();
    }

    protected static String getEntityLabel(Entity entity) {
        return String.format("%s (%s)", entity.getEntityName(), entity.getId());
    }

    protected static class ValidationResult {
        private final boolean isValid;
        private final String message;

        public ValidationResult() {
            this.isValid = true;
            this.message = "";
        }

        public ValidationResult(String message) {
            this.isValid = false;
            this.message = message;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

