/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.system.util;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.identifier.util.IdentifierValidator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.palladiosimulator.pcm.core.composition.util.CompositionValidator;
import org.palladiosimulator.pcm.core.entity.util.EntityValidator;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.system.SystemPackage;

public class SystemValidator
extends EObjectValidator {
    public static final String copyright = "Copyright 2005-2017 by palladiosimulator.org";
    public static final SystemValidator INSTANCE = new SystemValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.pcm.system";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected IdentifierValidator identifierValidator = IdentifierValidator.INSTANCE;
    protected CompositionValidator compositionValidator = CompositionValidator.INSTANCE;
    protected EntityValidator entityValidator = EntityValidator.INSTANCE;
    protected static final String SYSTEM__SYSTEM_MUST_HAVE_AT_LEAST_ONE_PROVIDED_ROLE__EEXPRESSION = "not self.providedRoles_InterfaceProvidingEntity->isEmpty()";

    protected EPackage getEPackage() {
        return SystemPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateSystem((System)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateSystem(System system, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(system, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(system, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.compositionValidator.validateComposedStructure_multipleConnectorsConstraint(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.compositionValidator.validateComposedStructure_multipleConnectorsConstraintForAssemblyConnectors(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.compositionValidator.validateComposedStructure_validateSameSubsystemMustNotBeInstantiatedMoreThanOnce(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.entityValidator.validateInterfaceProvidingEntity_needID(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.entityValidator.validateComposedProvidingRequiringEntity_operationProvidedRolesMustBeBound(system, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSystem_systemMustHaveAtLeastOneProvidedRole(system, diagnostics, context);
        }
        return result;
    }

    public boolean validateSystem_systemMustHaveAtLeastOneProvidedRole(System system, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(SystemPackage.Literals.SYSTEM, system, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "systemMustHaveAtLeastOneProvidedRole", SYSTEM__SYSTEM_MUST_HAVE_AT_LEAST_ONE_PROVIDED_ROLE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

