/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.commons.dialogs.stoex.impl;

import com.google.inject.Inject;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.RandomVariable;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.palladiosimulator.editors.commons.dialogs.stoex.StoExEditDialog;
import org.palladiosimulator.editors.commons.dialogs.stoex.impl.ObservableResourceValidator;
import org.palladiosimulator.editors.commons.dialogs.stoex.impl.StoexContextProvidingAdapterImpl;
import org.palladiosimulator.editors.commons.dialogs.stoex.impl.ViewerConfiguration;
import org.palladiosimulator.pcm.stoex.parser.antlr.PCMStoexParser;

public class StoExEditDialogImpl
extends TitleAreaDialog
implements StoExEditDialog {
    @Inject
    private ViewerConfiguration configuration;
    @Inject
    private EmbeddedEditorFactory embeddedEditorFactory;
    @Inject
    private IResourceValidator originalValidator;
    @Inject
    private IEditedResourceProvider editedResourceProvider;
    @Inject
    private ISerializer serializer;
    @Inject
    private PCMStoexParser parser;
    private final StoexContextProvidingAdapterImpl contextProvider = new StoexContextProvidingAdapterImpl();
    private EmbeddedEditorModelAccess modelAccess;
    private Expression initialExpression;
    private Expression result = null;
    private String resultString = null;
    private String title = "Edit a stochastic expression";

    public StoExEditDialogImpl(Shell parentShell, TypeEnum expectedType) {
        super(parentShell);
        this.contextProvider.setExpectedType(expectedType);
        this.setHelpAvailable(true);
    }

    @Override
    public void setInitialExpression(Expression expression) {
        this.initialExpression = expression;
    }

    @Override
    public void setDisplayTitle(String dialogMessage) {
        this.title = dialogMessage;
    }

    @Override
    public Expression getResult() {
        return this.result;
    }

    @Override
    public String getResultString() {
        return this.resultString;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.palladiosimulator.pcm.help.stoexdialog");
        Composite composite = (Composite)super.createDialogArea(parent);
        ObservableResourceValidator observableValidator = new ObservableResourceValidator(this.originalValidator);
        EmbeddedEditor embeddedEditor = this.embeddedEditorFactory.newEditor(this.editedResourceProvider).showErrorAndWarningAnnotations().withResourceValidator((IResourceValidator)observableValidator).withParent(composite);
        this.modelAccess = embeddedEditor.createPartialEditor();
        this.configuration.getHighlightingHelper().install(embeddedEditor.getConfiguration(), embeddedEditor.getViewer());
        embeddedEditor.getViewer().getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        embeddedEditor.getDocument().set(this.serialize(this.initialExpression));
        observableValidator.addValidationListener(this::processValidationResult);
        embeddedEditor.getDocument().readOnly(resource -> {
            resource.eAdapters().add((Object)this.contextProvider);
            return this.contextProvider;
        });
        composite.pack();
        return composite;
    }

    protected String serialize(Expression expression) {
        if (expression == null) {
            return "";
        }
        XtextResource r = this.editedResourceProvider.createResource();
        Expression copy = (Expression)EcoreUtil.copy((EObject)expression);
        r.getContents().add((Object)copy);
        return this.serializer.serialize((EObject)copy);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText("Edit stochastic expression");
        this.setTitle(this.title);
        return control;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.setResultVariables();
        super.okPressed();
    }

    protected void setResultVariables() {
        String resultText = this.modelAccess.getSerializedModel();
        IParseResult parseResult = this.parser.doParse((CharSequence)resultText);
        if (!parseResult.hasSyntaxErrors()) {
            this.result = (Expression)parseResult.getRootASTElement();
            this.resultString = this.serialize(this.result);
        }
    }

    protected void processValidationResult(Collection<Issue> issues) {
        Display.getDefault().asyncExec(() -> {
            Button okButton = this.getButton(0);
            if (issues.isEmpty()) {
                okButton.setEnabled(true);
            } else {
                okButton.setEnabled(false);
            }
        });
    }

    @Override
    public void setContext(RandomVariable context) {
        this.contextProvider.setStoexContainer(context);
    }
}

