/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.commons.dialogs.datatype;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;
import org.palladiosimulator.editors.commons.dialogs.datatype.InnerDeclarationItemProvider;
import org.palladiosimulator.editors.commons.dialogs.datatype.PalladioDataTypeDialog;
import org.palladiosimulator.editors.commons.dialogs.parameters.CreateEditorContents;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.InnerDeclaration;

public class InnerDeclarationCellModifier
implements ICellModifier {
    private PalladioDataTypeDialog dialog;
    private List<String> columnNames;
    private InnerDeclaration declaration;
    private TransactionalEditingDomain editingDomain;

    public InnerDeclarationCellModifier(PalladioDataTypeDialog dialog, TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.dialog = dialog;
        this.columnNames = Arrays.asList(CreateEditorContents.getColumnNames());
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        return new InnerDeclarationItemProvider(null).getColumnText(element, this.columnNames.indexOf(property));
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.columnNames.indexOf(property);
        Assert.isNotNull((Object)element);
        TableItem item = (TableItem)element;
        this.declaration = (InnerDeclaration)item.getData();
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                String valueString = ((String)value).trim();
                this.setDeclarationName(valueString);
                break;
            }
            case 2: {
                if (!(value instanceof DataType)) break;
                DataType valueDataType = (DataType)value;
                this.setDataType(valueDataType);
            }
        }
    }

    private void setDataType(final DataType dataType) {
        RecordingCommand recCommand = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                InnerDeclarationCellModifier.this.declaration.setDatatype_InnerDeclaration(dataType);
            }
        };
        if (!dataType.equals(this.declaration.getDatatype_InnerDeclaration())) {
            recCommand.setLabel("Set InnerDeclaration DataType");
            this.editingDomain.getCommandStack().execute((Command)recCommand);
        }
        this.reloadDeclarationViewer();
    }

    private void setDeclarationName(final String valueString) {
        RecordingCommand recCommand = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                InnerDeclarationCellModifier.this.declaration.setEntityName(valueString);
            }
        };
        if (!valueString.equals(this.declaration.getEntityName())) {
            recCommand.setLabel("Set InnerDeclaration name");
            this.editingDomain.getCommandStack().execute((Command)recCommand);
        }
        this.reloadDeclarationViewer();
    }

    private void reloadDeclarationViewer() {
        this.dialog.refresh();
    }
}

