package org.palladiosimulator.editors.commons.tabs.operations;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.palladiosimulator.editors.commons.tabs.generic.SelectionChangedListener;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureSignature;

/**Removes selected signatures from an infrastructure interface.
 * @author groenda
 *
 */
public class InfrastructureSignatureDeleteActionListener extends SelectionChangedListener implements SelectionListener {

	/**
	 * The transactional editing domain which is used to get the commands and
	 * alter the model
	 */
	private TransactionalEditingDomain editingDomain = null;


	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {

		final InfrastructureSignature selectedSignature = (InfrastructureSignature) getSelectedElement();
		Assert.isNotNull(selectedSignature);
		final InfrastructureInterface selectedInterface = (InfrastructureInterface) selectedSignature
				.getInfrastructureInterface__InfrastructureSignature();
		Assert.isNotNull(selectedInterface);
		editingDomain = TransactionUtil.getEditingDomain(selectedSignature);

		RecordingCommand recCommand = new RecordingCommand(editingDomain) {
			@Override
			protected void doExecute() {
				selectedInterface.getInfrastructureSignatures__InfrastructureInterface().remove(
						selectedSignature);
			}
		};

		recCommand.setDescription("Delete ...");
		editingDomain.getCommandStack().execute(recCommand);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
		// The implementation is not necessary.
	}
}
