/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.allocation.part;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class ResourceSelectorPage
extends WizardPage {
    private Text mySelectionText;
    private EObject myResolvedObject;

    protected EObject getResolvedObject() {
        return this.myResolvedObject;
    }

    protected ResourceSelectorPage(String name, EObject selectedResource) {
        super(name);
        this.setTitle("Diagram resource");
        this.setDescription("Select the resource to be used for the diagram.");
        this.myResolvedObject = selectedResource;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        this.setControl((Control)topLevel);
        this.createPageContent(topLevel);
        this.setPageComplete(this.doValidatePage());
    }

    private void createPageContent(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 0);
        label.setText("Selected resource:");
        label.setLayoutData((Object)new GridData(32));
        this.mySelectionText = new Text(panel, 8);
        this.mySelectionText.setText("none");
        if (this.myResolvedObject != null) {
            this.mySelectionText.setText(this.myResolvedObject.eResource().getURI().path());
        }
        this.mySelectionText.setLayoutData((Object)new GridData(2));
        this.mySelectionText.pack();
        Button button = new Button(panel, 0);
        button.setText("Change");
        button.setLayoutData((Object)new GridData(3));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = e.display.getActiveShell();
                LoadResourceAction.LoadResourceDialog dialog = new LoadResourceAction.LoadResourceDialog(shell);
                dialog.open();
                String uri = dialog.getURIText();
                if (uri != null) {
                    ResourceSelectorPage.this.mySelectionText.setText(dialog.getURIText());
                }
                ResourceSelectorPage.this.mySelectionText.pack();
                ResourceSelectorPage.this.resolveSelection();
                ResourceSelectorPage.this.setPageComplete(ResourceSelectorPage.this.validatePage());
            }
        });
    }

    protected boolean validatePage() {
        if (this.myResolvedObject == null) {
            this.setErrorMessage("No or invalid resource selected");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean doValidatePage() {
        return this.myResolvedObject != null;
    }

    private void resolveSelection() {
        this.myResolvedObject = null;
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        try {
            Resource resource = resourceSet.getResource(URI.createURI((String)this.mySelectionText.getText(), (boolean)true), true);
            this.myResolvedObject = (EObject)resource.getContents().get(0);
        }
        catch (WrappedException wrappedException) {}
    }
}

