/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.composite.custom;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;

public abstract class AbstractBorderFigure
extends DefaultSizeNodeFigure {
    private final POSITION_TYPE myPosType;
    private ConnectionAnchor myAnchor = null;

    public AbstractBorderFigure(int logicalSize, POSITION_TYPE posType) {
        super(logicalSize, logicalSize);
        this.myPosType = posType;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.setLineWidthFloat(new Float(1.01).floatValue());
    }

    protected IBorderItemLocator getBorderItemLocator() {
        Object constraint;
        IFigure parentFigure = this.getParent().getParent();
        if (parentFigure != null && parentFigure.getLayoutManager() != null && (constraint = parentFigure.getLayoutManager().getConstraint(this.getParent())) instanceof IBorderItemLocator) {
            return (IBorderItemLocator)constraint;
        }
        return null;
    }

    protected abstract ConnectionAnchor createAnchorInternal();

    protected abstract ConnectionAnchor createAnchorExternal();

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        if (this.myAnchor == null) {
            if (this.myPosType == POSITION_TYPE.POS_INTERNAL) {
                this.myAnchor = this.createAnchorInternal();
            }
            if (this.myPosType == POSITION_TYPE.POS_EXTERNAL) {
                this.myAnchor = this.createAnchorExternal();
            }
        }
        assert (this.myAnchor != null);
        return this.myAnchor;
    }

    private Point getStemPosition() {
        int side = this.getBorderItemLocator() == null ? 8 : this.getBorderItemLocator().getCurrentSideOfParent();
        Rectangle rect = this.getBounds();
        Point result = null;
        switch (side) {
            case 16: {
                result = new Point(rect.getLeft().x, rect.getCenter().y);
                break;
            }
            case 8: {
                result = new Point(rect.getRight().x, rect.getCenter().y);
                break;
            }
            case 1: {
                result = new Point(rect.getCenter().x, rect.getBottom().y);
                break;
            }
            case 4: {
                result = new Point(rect.getCenter().x, rect.getTop().y);
            }
        }
        return result;
    }

    public static enum POSITION_TYPE {
        POS_INTERNAL,
        POS_EXTERNAL;

    }

    protected class StemAnchor
    extends AbstractConnectionAnchor {
        public StemAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Point p = AbstractBorderFigure.this.getStemPosition();
            this.getOwner().translateToAbsolute((Translatable)p);
            return p;
        }
    }
}

