/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.composite.navigator;

import de.uka.ipd.sdq.pcm.gmf.composite.navigator.PalladioComponentModelAbstractNavigatorItem;
import de.uka.ipd.sdq.pcm.gmf.composite.navigator.PalladioComponentModelNavigatorGroup;
import de.uka.ipd.sdq.pcm.gmf.composite.navigator.PalladioComponentModelNavigatorItem;
import de.uka.ipd.sdq.pcm.gmf.composite.part.Messages;
import de.uka.ipd.sdq.pcm.gmf.composite.part.PalladioComponentModelVisualIDRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class PalladioComponentModelNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public PalladioComponentModelNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (PalladioComponentModelNavigatorContentProvider.this.myViewer != null) {
                    PalladioComponentModelNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                PalladioComponentModelNavigatorContentProvider.this.unloadAllResources();
                PalladioComponentModelNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                PalladioComponentModelNavigatorContentProvider.this.unloadAllResources();
                PalladioComponentModelNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                PalladioComponentModelNavigatorContentProvider.this.unloadAllResources();
                PalladioComponentModelNavigatorContentProvider.this.asyncRefresh();
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        this.myViewer = null;
        this.unloadAllResources();
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    void unloadAllResources() {
        for (Resource nextResource : this.myEditingDomain.getResourceSet().getResources()) {
            nextResource.unload();
        }
    }

    void asyncRefresh() {
        if (this.myViewer != null && !this.myViewer.getControl().isDisposed()) {
            this.myViewer.getControl().getDisplay().asyncExec(this.myViewerRefreshRunnable);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList<PalladioComponentModelNavigatorItem> result = new ArrayList<PalladioComponentModelNavigatorItem>();
            ArrayList<View> topViews = new ArrayList<View>(resource.getContents().size());
            for (EObject o : resource.getContents()) {
                if (!(o instanceof View)) continue;
                topViews.add((View)o);
            }
            result.addAll(this.createNavigatorItems(this.selectViewsByType(topViews, "CompositeModel"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof PalladioComponentModelNavigatorGroup) {
            PalladioComponentModelNavigatorGroup group = (PalladioComponentModelNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof PalladioComponentModelNavigatorItem) {
            PalladioComponentModelNavigatorItem navigatorItem = (PalladioComponentModelNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (PalladioComponentModelVisualIDRegistry.getVisualID(view)) {
            case 4008: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Edge sv = (Edge)view;
                PalladioComponentModelNavigatorGroup target = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_AssemblyInfrastructureConnector_4008_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup source = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_AssemblyInfrastructureConnector_4008_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3015));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3016));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4010: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Edge sv = (Edge)view;
                PalladioComponentModelNavigatorGroup target = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_EventChannelSinkConnector_4010_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup source = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_EventChannelSinkConnector_4010_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3017));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3014));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4007: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Edge sv = (Edge)view;
                PalladioComponentModelNavigatorGroup target = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_AssemblyEventConnector_4007_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup source = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_AssemblyEventConnector_4007_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3014));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3013));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4006: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Edge sv = (Edge)view;
                PalladioComponentModelNavigatorGroup target = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_ProvidedDelegationConnector_4006_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup source = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_ProvidedDelegationConnector_4006_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3011));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 3017: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Node sv = (Node)view;
                PalladioComponentModelNavigatorGroup incominglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_EventChannel_3017_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4010));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4009));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3008: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Node sv = (Node)view;
                PalladioComponentModelNavigatorGroup outgoinglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_OperationRequiredRole_3008_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup incominglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_OperationRequiredRole_3008_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4004));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4005));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4005));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3013: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Node sv = (Node)view;
                PalladioComponentModelNavigatorGroup outgoinglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_SourceRole_3013_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4009));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4007));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4005: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Edge sv = (Edge)view;
                PalladioComponentModelNavigatorGroup target = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_RequiredDelegationConnector_4005_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup source = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_RequiredDelegationConnector_4005_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3008));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3012));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3008));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3012));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 1000: {
                LinkedList<PalladioComponentModelAbstractNavigatorItem> result = new LinkedList<PalladioComponentModelAbstractNavigatorItem>();
                Diagram sv = (Diagram)view;
                PalladioComponentModelNavigatorGroup links = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_ComposedProvidingRequiringEntity_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(2002));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4010));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4009));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4004));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4007));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4005));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4006));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4008));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
            case 3014: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Node sv = (Node)view;
                PalladioComponentModelNavigatorGroup outgoinglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_SinkRole_3014_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup incominglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_SinkRole_3014_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4010));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4007));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3016: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Node sv = (Node)view;
                PalladioComponentModelNavigatorGroup outgoinglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_InfrastructureRequiredRole_3016_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4008));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3006: {
                LinkedList<PalladioComponentModelNavigatorItem> result = new LinkedList<PalladioComponentModelNavigatorItem>();
                Node sv = (Node)view;
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3007));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3008));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3013));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3014));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3015));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3016));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
            case 4009: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Edge sv = (Edge)view;
                PalladioComponentModelNavigatorGroup target = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_EventChannelSourceConnector_4009_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup source = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_EventChannelSourceConnector_4009_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3017));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3013));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 3007: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Node sv = (Node)view;
                PalladioComponentModelNavigatorGroup incominglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_OperationProvidedRole_3007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup outgoinglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_OperationProvidedRole_3007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4004));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3011: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Node sv = (Node)view;
                PalladioComponentModelNavigatorGroup incominglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_OperationProvidedRole_3011_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup outgoinglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_OperationProvidedRole_3011_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4004));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4006));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4006));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2002: {
                LinkedList<PalladioComponentModelNavigatorItem> result = new LinkedList<PalladioComponentModelNavigatorItem>();
                Node sv = (Node)view;
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, PalladioComponentModelVisualIDRegistry.getType(3006));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3011));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3012));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, PalladioComponentModelVisualIDRegistry.getType(3017));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
            case 4004: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Edge sv = (Edge)view;
                PalladioComponentModelNavigatorGroup target = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_AssemblyConnector_4004_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup source = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_AssemblyConnector_4004_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3011));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3008));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(3012));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 3012: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Node sv = (Node)view;
                PalladioComponentModelNavigatorGroup outgoinglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_OperationRequiredRole_3012_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                PalladioComponentModelNavigatorGroup incominglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_OperationRequiredRole_3012_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4004));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4005));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4005));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3015: {
                LinkedList<PalladioComponentModelNavigatorGroup> result = new LinkedList<PalladioComponentModelNavigatorGroup>();
                Node sv = (Node)view;
                PalladioComponentModelNavigatorGroup incominglinks = new PalladioComponentModelNavigatorGroup(Messages.NavigatorGroupName_InfrastructureProvidedRole_3015_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), PalladioComponentModelVisualIDRegistry.getType(4008));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection<View> getLinksSourceByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection<View> getLinksTargetByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection<View> getOutgoingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getSourceEdges(), type));
        }
        return result;
    }

    private Collection<View> getIncomingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getTargetEdges(), type));
        }
        return result;
    }

    private Collection<View> getChildrenByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getChildren(), type));
        }
        return result;
    }

    private Collection<View> getDiagramLinksByType(Collection<Diagram> diagrams, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection<View>)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection<View> selectViewsByType(Collection<View> views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "CompositeModel".equals(PalladioComponentModelVisualIDRegistry.getModelID(view));
    }

    private Collection<PalladioComponentModelNavigatorItem> createNavigatorItems(Collection<View> views, Object parent, boolean isLeafs) {
        ArrayList<PalladioComponentModelNavigatorItem> result = new ArrayList<PalladioComponentModelNavigatorItem>(views.size());
        for (View nextView : views) {
            result.add(new PalladioComponentModelNavigatorItem(nextView, parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof PalladioComponentModelAbstractNavigatorItem) {
            PalladioComponentModelAbstractNavigatorItem abstractNavigatorItem = (PalladioComponentModelAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

