/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.repository.part;

import de.uka.ipd.sdq.pcm.gmf.repository.part.PalladioComponentModelRepositoryDiagramEditorPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.palladiosimulator.pcm.parameter.ParameterPackage;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.seff.SeffPackage;
import org.palladiosimulator.pcm.subsystem.SubsystemPackage;

public class PalladioComponentModelVisualIDRegistry {
    private static final String DEBUG_KEY = "de.uka.ipd.sdq.pcm.gmf.repository/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return PalladioComponentModelVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return PalladioComponentModelVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return PalladioComponentModelVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return PalladioComponentModelVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return PalladioComponentModelVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return PalladioComponentModelVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PCM Repository Model".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return PalladioComponentModelVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                PalladioComponentModelRepositoryDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (RepositoryPackage.eINSTANCE.getRepository().isSuperTypeOf(domainElement.eClass()) && PalladioComponentModelVisualIDRegistry.isDiagram((Repository)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = PalladioComponentModelVisualIDRegistry.getModelID(containerView);
        if (!"PCM Repository Model".equals(containerModelID)) {
            return -1;
        }
        if ("PCM Repository Model".equals(containerModelID)) {
            containerVisualID = PalladioComponentModelVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (RepositoryPackage.eINSTANCE.getOperationInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2107;
                }
                if (RepositoryPackage.eINSTANCE.getEventGroup().isSuperTypeOf(domainElement.eClass())) {
                    return 2108;
                }
                if (RepositoryPackage.eINSTANCE.getBasicComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2102;
                }
                if (RepositoryPackage.eINSTANCE.getCompositeComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2103;
                }
                if (RepositoryPackage.eINSTANCE.getCompleteComponentType().isSuperTypeOf(domainElement.eClass())) {
                    return 2104;
                }
                if (RepositoryPackage.eINSTANCE.getProvidesComponentType().isSuperTypeOf(domainElement.eClass())) {
                    return 2105;
                }
                if (SubsystemPackage.eINSTANCE.getSubSystem().isSuperTypeOf(domainElement.eClass())) {
                    return 2106;
                }
                if (!RepositoryPackage.eINSTANCE.getInfrastructureInterface().isSuperTypeOf(domainElement.eClass())) break;
                return 2109;
            }
            case 7106: {
                if (!RepositoryPackage.eINSTANCE.getOperationSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3106;
            }
            case 7107: {
                if (!RepositoryPackage.eINSTANCE.getEventType().isSuperTypeOf(domainElement.eClass())) break;
                return 3107;
            }
            case 7102: {
                if (!SeffPackage.eINSTANCE.getResourceDemandingSEFF().isSuperTypeOf(domainElement.eClass())) break;
                return 3102;
            }
            case 7103: {
                if (!RepositoryPackage.eINSTANCE.getPassiveResource().isSuperTypeOf(domainElement.eClass())) break;
                return 3103;
            }
            case 7104: {
                if (!ParameterPackage.eINSTANCE.getVariableUsage().isSuperTypeOf(domainElement.eClass())) break;
                return 3104;
            }
            case 7105: {
                if (!ParameterPackage.eINSTANCE.getVariableCharacterisation().isSuperTypeOf(domainElement.eClass())) break;
                return 3105;
            }
            case 7108: {
                if (!RepositoryPackage.eINSTANCE.getInfrastructureSignature().isSuperTypeOf(domainElement.eClass())) break;
                return 3108;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = PalladioComponentModelVisualIDRegistry.getModelID(containerView);
        if (!"PCM Repository Model".equals(containerModelID)) {
            return false;
        }
        if ("PCM Repository Model".equals(containerModelID)) {
            containerVisualID = PalladioComponentModelVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2107 == nodeVisualID) {
                    return true;
                }
                if (2108 == nodeVisualID) {
                    return true;
                }
                if (2102 == nodeVisualID) {
                    return true;
                }
                if (2103 == nodeVisualID) {
                    return true;
                }
                if (2104 == nodeVisualID) {
                    return true;
                }
                if (2105 == nodeVisualID) {
                    return true;
                }
                if (2106 == nodeVisualID) {
                    return true;
                }
                if (2109 != nodeVisualID) break;
                return true;
            }
            case 2107: {
                if (5108 == nodeVisualID) {
                    return true;
                }
                if (7106 != nodeVisualID) break;
                return true;
            }
            case 2108: {
                if (5109 == nodeVisualID) {
                    return true;
                }
                if (7107 != nodeVisualID) break;
                return true;
            }
            case 2102: {
                if (5102 == nodeVisualID) {
                    return true;
                }
                if (7102 == nodeVisualID) {
                    return true;
                }
                if (7103 == nodeVisualID) {
                    return true;
                }
                if (7104 != nodeVisualID) break;
                return true;
            }
            case 2103: {
                if (5103 != nodeVisualID) break;
                return true;
            }
            case 2104: {
                if (5104 != nodeVisualID) break;
                return true;
            }
            case 2105: {
                if (5105 != nodeVisualID) break;
                return true;
            }
            case 2106: {
                if (5107 != nodeVisualID) break;
                return true;
            }
            case 2109: {
                if (5110 == nodeVisualID) {
                    return true;
                }
                if (7108 != nodeVisualID) break;
                return true;
            }
            case 3104: {
                if (5106 == nodeVisualID) {
                    return true;
                }
                if (7105 != nodeVisualID) break;
                return true;
            }
            case 7106: {
                if (3106 != nodeVisualID) break;
                return true;
            }
            case 7107: {
                if (3107 != nodeVisualID) break;
                return true;
            }
            case 7102: {
                if (3102 != nodeVisualID) break;
                return true;
            }
            case 7103: {
                if (3103 != nodeVisualID) break;
                return true;
            }
            case 7104: {
                if (3104 != nodeVisualID) break;
                return true;
            }
            case 7105: {
                if (3105 != nodeVisualID) break;
                return true;
            }
            case 7108: {
                if (3108 != nodeVisualID) break;
                return true;
            }
            case 4105: {
                if (6105 != nodeVisualID) break;
                return true;
            }
            case 4111: {
                if (6111 != nodeVisualID) break;
                return true;
            }
            case 4112: {
                if (6112 != nodeVisualID) break;
                return true;
            }
            case 4109: {
                if (6109 != nodeVisualID) break;
                return true;
            }
            case 4106: {
                if (6106 != nodeVisualID) break;
                return true;
            }
            case 4103: {
                if (6103 != nodeVisualID) break;
                return true;
            }
            case 4104: {
                if (6104 != nodeVisualID) break;
                return true;
            }
            case 4110: {
                if (6110 != nodeVisualID) break;
                return true;
            }
            case 4113: {
                if (6113 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (RepositoryPackage.eINSTANCE.getOperationProvidedRole().isSuperTypeOf(domainElement.eClass())) {
            return 4105;
        }
        if (RepositoryPackage.eINSTANCE.getInfrastructureProvidedRole().isSuperTypeOf(domainElement.eClass())) {
            return 4111;
        }
        if (RepositoryPackage.eINSTANCE.getInfrastructureRequiredRole().isSuperTypeOf(domainElement.eClass())) {
            return 4112;
        }
        if (RepositoryPackage.eINSTANCE.getSinkRole().isSuperTypeOf(domainElement.eClass())) {
            return 4109;
        }
        if (RepositoryPackage.eINSTANCE.getOperationRequiredRole().isSuperTypeOf(domainElement.eClass())) {
            return 4106;
        }
        if (RepositoryPackage.eINSTANCE.getSourceRole().isSuperTypeOf(domainElement.eClass())) {
            return 4110;
        }
        return -1;
    }

    private static boolean isDiagram(Repository element) {
        return true;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = PalladioComponentModelVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7102: 
            case 7103: 
            case 7104: 
            case 7105: 
            case 7106: 
            case 7107: 
            case 7108: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 2103: 
            case 2104: 
            case 2105: 
            case 2106: 
            case 3102: 
            case 3103: 
            case 3105: 
            case 3106: 
            case 3107: 
            case 3108: {
                return true;
            }
        }
        return false;
    }
}

