/*
 * Copyright 2006 SDQ Research Group, University of Karlsruhe (TH)
 */
package de.uka.ipd.sdq.pcm.gmf.seff.parsers;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.Locale;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.osgi.util.NLS;

import de.uka.ipd.sdq.pcm.gmf.seff.part.Messages;
import de.uka.ipd.sdq.pcm.gmf.seff.part.PalladioComponentModelSeffDiagramEditorPlugin;

/**
 * @generated
 */
public class MessageFormatParser extends AbstractParser {

    /**
     * @generated
     */
    private String defaultPattern;

    /**
     * @generated
     */
    private String defaultEditablePattern;

    /**
     * The international locale. @generated not Stores the current Locale, needed to ensure correct
     * display of decimal values.
     */
    private final Locale internationalLocale = Locale.US;

    /**
     * @generated
     */
    private MessageFormat viewProcessor;

    /**
     * @generated
     */
    private MessageFormat editorProcessor;

    /**
     * @generated
     */
    private MessageFormat editProcessor;

    /**
     * @generated
     */
    public MessageFormatParser(EAttribute[] features) {
        super(features);
    }

    /**
     * @generated
     */
    public MessageFormatParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    /**
     * @generated
     */
    protected String getDefaultPattern() {
        if (defaultPattern == null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < features.length; i++) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append('{');
                sb.append(i);
                sb.append('}');
            }
            defaultPattern = sb.toString();
        }
        return defaultPattern;
    }

    /**
     * @generated
     */
    public void setViewPattern(String viewPattern) {
        super.setViewPattern(viewPattern);
        viewProcessor = null;
    }

    /**
     * Gets the view processor.
     * 
     * @return the view processor
     * @generated not Changes made to generated Method: Added internationalLocale to ensure correct
     *            display of decimal values.
     */
    protected MessageFormat getViewProcessor() {
        if (viewProcessor == null) {
            viewProcessor = new MessageFormat(getViewPattern() == null ? getDefaultPattern() : getViewPattern(),
                    internationalLocale);
        }
        return viewProcessor;
    }

    /**
     * @generated
     */
    public void setEditorPattern(String editorPattern) {
        super.setEditorPattern(editorPattern);
        editorProcessor = null;
    }

    /**
     * Gets the editor processor.
     * 
     * @return the editor processor
     * @generated not Changes made to generated Method: Added internationalLocale to ensure correct
     *            display of decimal values.
     */
    protected MessageFormat getEditorProcessor() {
        if (editorProcessor == null) {
            editorProcessor = new MessageFormat(getEditorPattern() == null ? getDefaultEditablePattern()
                    : getEditorPattern(), internationalLocale);
        }
        return editorProcessor;
    }

    /**
     * @generated
     */
    protected String getDefaultEditablePattern() {
        if (defaultEditablePattern == null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < editableFeatures.length; i++) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append('{');
                sb.append(i);
                sb.append('}');
            }
            defaultEditablePattern = sb.toString();
        }
        return defaultEditablePattern;
    }

    /**
     * @generated
     */
    public void setEditPattern(String editPattern) {
        super.setEditPattern(editPattern);
        editProcessor = null;
    }

    /**
     * Gets the edits the processor.
     * 
     * @return the edits the processor
     * @generated not Changes made to generated Method: Added internationalLocale to ensure correct
     *            display of decimal values.
     */
    protected MessageFormat getEditProcessor() {
        if (editProcessor == null) {
            editProcessor = new MessageFormat(
                    getEditPattern() == null ? getDefaultEditablePattern() : getEditPattern(), internationalLocale);
        }
        return editProcessor;
    }

    /**
     * @generated
     */
    public String getPrintString(IAdaptable adapter, int flags) {
        EObject element = (EObject) adapter.getAdapter(EObject.class);
        return getViewProcessor().format(getValues(element), new StringBuffer(), new FieldPosition(0)).toString();
    }

    /**
     * @generated
     */
    public String getEditString(IAdaptable adapter, int flags) {
        EObject element = (EObject) adapter.getAdapter(EObject.class);
        return getEditorProcessor().format(getEditableValues(element), new StringBuffer(), new FieldPosition(0))
                .toString();
    }

    /**
     * @generated
     */
    public IParserEditStatus isValidEditString(IAdaptable adapter, String editString) {
        ParsePosition pos = new ParsePosition(0);
        Object[] values = getEditProcessor().parse(editString, pos);
        if (values == null) {
            return new ParserEditStatus(PalladioComponentModelSeffDiagramEditorPlugin.ID, IParserEditStatus.UNEDITABLE,
                    NLS.bind(Messages.MessageFormatParser_InvalidInputError, new Integer(pos.getErrorIndex())));
        }
        return validateNewValues(values);
    }

    /**
     * @generated
     */
    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        Object[] values = getEditProcessor().parse(newString, new ParsePosition(0));
        return getParseCommand(adapter, values, flags);
    }
}
