/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.seff.parsers;

import de.uka.ipd.sdq.pcm.gmf.seff.parsers.AbstractParser;
import de.uka.ipd.sdq.pcm.gmf.seff.part.Messages;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.osgi.util.NLS;

public class MessageFormatParser
extends AbstractParser {
    private String defaultPattern;
    private String defaultEditablePattern;
    private final Locale internationalLocale = Locale.US;
    private MessageFormat viewProcessor;
    private MessageFormat editorProcessor;
    private MessageFormat editProcessor;

    public MessageFormatParser(EAttribute[] features) {
        super(features);
    }

    public MessageFormatParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    protected String getDefaultPattern() {
        if (this.defaultPattern == null) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.features.length) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append('{');
                sb.append(i);
                sb.append('}');
                ++i;
            }
            this.defaultPattern = sb.toString();
        }
        return this.defaultPattern;
    }

    @Override
    public void setViewPattern(String viewPattern) {
        super.setViewPattern(viewPattern);
        this.viewProcessor = null;
    }

    protected MessageFormat getViewProcessor() {
        if (this.viewProcessor == null) {
            this.viewProcessor = new MessageFormat(this.getViewPattern() == null ? this.getDefaultPattern() : this.getViewPattern(), this.internationalLocale);
        }
        return this.viewProcessor;
    }

    @Override
    public void setEditorPattern(String editorPattern) {
        super.setEditorPattern(editorPattern);
        this.editorProcessor = null;
    }

    protected MessageFormat getEditorProcessor() {
        if (this.editorProcessor == null) {
            this.editorProcessor = new MessageFormat(this.getEditorPattern() == null ? this.getDefaultEditablePattern() : this.getEditorPattern(), this.internationalLocale);
        }
        return this.editorProcessor;
    }

    protected String getDefaultEditablePattern() {
        if (this.defaultEditablePattern == null) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.editableFeatures.length) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append('{');
                sb.append(i);
                sb.append('}');
                ++i;
            }
            this.defaultEditablePattern = sb.toString();
        }
        return this.defaultEditablePattern;
    }

    @Override
    public void setEditPattern(String editPattern) {
        super.setEditPattern(editPattern);
        this.editProcessor = null;
    }

    protected MessageFormat getEditProcessor() {
        if (this.editProcessor == null) {
            this.editProcessor = new MessageFormat(this.getEditPattern() == null ? this.getDefaultEditablePattern() : this.getEditPattern(), this.internationalLocale);
        }
        return this.editProcessor;
    }

    public String getPrintString(IAdaptable adapter, int flags) {
        EObject element = (EObject)adapter.getAdapter(EObject.class);
        return this.getViewProcessor().format(this.getValues(element), new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String getEditString(IAdaptable adapter, int flags) {
        EObject element = (EObject)adapter.getAdapter(EObject.class);
        return this.getEditorProcessor().format(this.getEditableValues(element), new StringBuffer(), new FieldPosition(0)).toString();
    }

    public IParserEditStatus isValidEditString(IAdaptable adapter, String editString) {
        ParsePosition pos = new ParsePosition(0);
        Object[] values = this.getEditProcessor().parse(editString, pos);
        if (values == null) {
            return new ParserEditStatus("de.uka.ipd.sdq.pcm.gmf.seff", 1, NLS.bind((String)Messages.MessageFormatParser_InvalidInputError, (Object)new Integer(pos.getErrorIndex())));
        }
        return this.validateNewValues(values);
    }

    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        Object[] values = this.getEditProcessor().parse(newString, new ParsePosition(0));
        return this.getParseCommand(adapter, values, flags);
    }
}

