/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.seff.part;

import de.uka.ipd.sdq.pcm.gmf.seff.part.Messages;
import de.uka.ipd.sdq.pcm.gmf.seff.part.ModelElementSelectionPage;
import de.uka.ipd.sdq.pcm.gmf.seff.part.PalladioComponentModelDiagramEditorUtil;
import de.uka.ipd.sdq.pcm.gmf.seff.part.PalladioComponentModelSeffDiagramEditorPlugin;
import de.uka.ipd.sdq.pcm.gmf.seff.part.PalladioComponentModelVisualIDRegistry;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;

public class PalladioComponentModelNewDiagramFileWizard
extends Wizard {
    private WizardNewFileCreationPage myFileCreationPage;
    private ModelElementSelectionPage diagramRootElementSelectionPage;
    private TransactionalEditingDomain myEditingDomain;
    private final WizardNewFileCreationPage myDiagramFilenameSelectionPage;
    private final DiagramRootElementSelectionPage myDiagramRootElementSelectionPage;

    public PalladioComponentModelNewDiagramFileWizard(URI domainModelURI, EObject diagramRoot, TransactionalEditingDomain editingDomain) {
        Path filePath;
        assert (domainModelURI != null) : "Domain model uri must be specified";
        assert (diagramRoot != null) : "Doagram root element must be specified";
        assert (editingDomain != null) : "Editing domain must be specified";
        this.myDiagramFilenameSelectionPage = new WizardNewFileCreationPage(Messages.PalladioComponentModelNewDiagramFileWizard_CreationPageName, (IStructuredSelection)StructuredSelection.EMPTY);
        this.myDiagramFilenameSelectionPage.setTitle(Messages.PalladioComponentModelNewDiagramFileWizard_CreationPageTitle);
        this.myDiagramFilenameSelectionPage.setDescription(NLS.bind((String)Messages.PalladioComponentModelNewDiagramFileWizard_CreationPageDescription, (Object)"PCM SEFF Model"));
        this.myDiagramFilenameSelectionPage.setFileExtension("seff_diagram");
        if (domainModelURI.isPlatformResource()) {
            filePath = new Path(domainModelURI.trimSegments(1).toPlatformString(true));
        } else if (domainModelURI.isFile()) {
            filePath = new Path(domainModelURI.trimSegments(1).toFileString());
        } else {
            throw new IllegalArgumentException("Unsupported URI: " + domainModelURI);
        }
        this.myDiagramFilenameSelectionPage.setContainerFullPath((IPath)filePath);
        this.myDiagramRootElementSelectionPage = new DiagramRootElementSelectionPage(Messages.PalladioComponentModelNewDiagramFileWizard_RootSelectionPageName, diagramRoot);
        this.myDiagramRootElementSelectionPage.setTitle(Messages.PalladioComponentModelNewDiagramFileWizard_RootSelectionPageTitle);
        this.myDiagramRootElementSelectionPage.setDescription(Messages.PalladioComponentModelNewDiagramFileWizard_RootSelectionPageDescription);
        this.myEditingDomain = editingDomain;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.myDiagramRootElementSelectionPage);
        this.addPage((IWizardPage)this.myDiagramFilenameSelectionPage);
    }

    public boolean performFinish() {
        LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
        IFile diagramFile = this.myDiagramFilenameSelectionPage.createNewFile();
        try {
            diagramFile.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            PalladioComponentModelSeffDiagramEditorPlugin.getInstance().logError("Unable to set charset for diagram file", e);
        }
        affectedFiles.add(diagramFile);
        URI diagramModelURI = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
        ResourceSet resourceSet = this.myEditingDomain.getResourceSet();
        final Resource diagramResource = resourceSet.createResource(diagramModelURI);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(this.myEditingDomain, "Initializing diagram contents", affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int diagramVID = PalladioComponentModelVisualIDRegistry.getDiagramVisualID((EObject)PalladioComponentModelNewDiagramFileWizard.this.myDiagramRootElementSelectionPage.getSeff());
                if (diagramVID != 1000) {
                    return CommandResult.newErrorCommandResult((String)"Incorrect model object stored as a root resource object");
                }
                Diagram diagram = ViewService.createDiagram((EObject)PalladioComponentModelNewDiagramFileWizard.this.myDiagramRootElementSelectionPage.getSeff(), (String)"PCM SEFF Model", (PreferencesHint)PalladioComponentModelSeffDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                diagramResource.getContents().add((Object)diagram);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            diagramResource.save(Collections.EMPTY_MAP);
            PalladioComponentModelDiagramEditorUtil.openDiagram(diagramResource);
        }
        catch (ExecutionException e) {
            PalladioComponentModelSeffDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        catch (IOException ex) {
            PalladioComponentModelSeffDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + diagramModelURI, ex);
        }
        catch (PartInitException ex) {
            PalladioComponentModelSeffDiagramEditorPlugin.getInstance().logError("Unable to open editor", ex);
        }
        return true;
    }

    private class DiagramRootElementSelectionPage
    extends WizardPage {
        private Combo myCombo;
        private List<ResourceDemandingSEFF> myFoundSeffs;
        private EObject myDiagramRoot;
        private ResourceDemandingSEFF mySeff;

        protected DiagramRootElementSelectionPage(String pageName) {
            super(pageName);
        }

        protected DiagramRootElementSelectionPage(String pageName, EObject diagramRoot) {
            super(pageName);
            this.myCombo = null;
            this.myFoundSeffs = new Vector<ResourceDemandingSEFF>();
            this.myDiagramRoot = diagramRoot;
            this.mySeff = null;
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite topLevel = new Composite(parent, 0);
            topLevel.setLayout((Layout)new GridLayout());
            topLevel.setLayoutData((Object)new GridData(272));
            topLevel.setFont(parent.getFont());
            this.setControl((Control)topLevel);
            this.createPageContent(topLevel);
            this.setPageComplete(this.validatePage());
        }

        private void createPageContent(Composite parent) {
            Composite panel = new Composite(parent, 0);
            panel.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout();
            panel.setLayout((Layout)layout);
            Label label = new Label(panel, 0);
            label.setText("Select Resource Demanding SEFF:");
            label.setLayoutData((Object)new GridData(32));
            this.myCombo = new Combo(panel, 12);
            this.findSeffs();
            this.populateComboBox();
            this.myCombo.addSelectionListener((SelectionListener)new ComboSelectionListener());
        }

        private void populateComboBox() {
            if (this.myCombo == null) {
                return;
            }
            this.myCombo.removeAll();
            for (ResourceDemandingSEFF seff : this.myFoundSeffs) {
                this.myCombo.add("Container: " + this.getComponentNameFromSEFF(seff) + " - SEFF " + this.getServiceNameFromSEFF(seff) + " id: " + seff.getId());
            }
        }

        protected String getComponentNameFromSEFF(ResourceDemandingSEFF seff) {
            EObject container = seff.eContainer();
            if (container instanceof BasicComponent) {
                BasicComponent component = (BasicComponent)container;
                return component.getEntityName();
            }
            return "";
        }

        protected String getServiceNameFromSEFF(ResourceDemandingSEFF seff) {
            return seff.getDescribedService__SEFF() == null ? "" : seff.getDescribedService__SEFF().getEntityName();
        }

        private void findSeffs() {
            this.myFoundSeffs.clear();
            TreeIterator it = this.myDiagramRoot.eAllContents();
            while (it.hasNext()) {
                EObject possibleSeff = (EObject)it.next();
                if (!(possibleSeff instanceof ResourceDemandingSEFF)) continue;
                this.myFoundSeffs.add((ResourceDemandingSEFF)possibleSeff);
            }
        }

        protected String getSelectionTitle() {
            return Messages.PalladioComponentModelNewDiagramFileWizard_RootSelectionPageSelectionTitle;
        }

        protected ResourceDemandingSEFF getSeff() {
            return this.mySeff;
        }

        protected boolean validatePage() {
            this.mySeff = null;
            if (this.myCombo.getSelectionIndex() == -1) {
                return false;
            }
            try {
                this.mySeff = this.myFoundSeffs.get(this.myCombo.getSelectionIndex());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
            String filename = String.valueOf(this.getComponentNameFromSEFF(this.mySeff)) + "." + this.getServiceNameFromSEFF(this.mySeff) + ".seff_diagram";
            PalladioComponentModelNewDiagramFileWizard.this.myDiagramFilenameSelectionPage.setFileName(filename);
            return true;
        }

        private class ComboSelectionListener
        implements SelectionListener {
            private ComboSelectionListener() {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DiagramRootElementSelectionPage.this.setPageComplete(DiagramRootElementSelectionPage.this.validatePage());
            }

            public void widgetSelected(SelectionEvent e) {
                DiagramRootElementSelectionPage.this.setPageComplete(DiagramRootElementSelectionPage.this.validatePage());
            }
        }
    }
}

