/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.ui;

import de.uka.ipd.sdq.pcm.gmf.ui.DescriptionBox;
import de.uka.ipd.sdq.pcm.gmf.ui.PalladioTemplate;
import de.uka.ipd.sdq.pcm.gmf.ui.TemplateLabelProvider;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewPalladioTemplateWizardPage
extends WizardPage
implements ISelectionChangedListener {
    protected TableViewer wizardSelectionViewer;
    private DescriptionBox descriptionBrowser;
    private Set<PalladioTemplate> availableTemplates;
    private PalladioTemplate selectedTemplate;

    public NewPalladioTemplateWizardPage(Set<PalladioTemplate> availableTemplates) {
        super("Template Selection");
        this.setTitle("Palladio Model Template Selection");
        this.setDescription("Select a template to create an initial Palladio model.");
        this.availableTemplates = availableTemplates;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(this.getTitle());
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        SashForm sashForm = new SashForm(container, 256);
        gd = new GridData(1808);
        gd.widthHint = 300;
        sashForm.setLayoutData((Object)gd);
        this.wizardSelectionViewer = new TableViewer((Composite)sashForm, 2048);
        this.wizardSelectionViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.createDescriptionIn((Composite)sashForm);
        this.wizardSelectionViewer.setInput(this.availableTemplates);
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setControl((Control)container);
    }

    public void createDescriptionIn(Composite composite) {
        this.descriptionBrowser = new DescriptionBox(4);
        this.descriptionBrowser.createControl(composite);
        Control c = this.descriptionBrowser.getControl();
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        c.setLayoutData((Object)gd);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setErrorMessage(null);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        PalladioTemplate currentTemplateSelection = null;
        Iterator iter = selection.iterator();
        if (iter.hasNext()) {
            currentTemplateSelection = (PalladioTemplate)iter.next();
        }
        if (currentTemplateSelection == null) {
            this.setSelectedTemplate(null);
            return;
        }
        this.setSelectedTemplate(currentTemplateSelection);
        this.getContainer().updateButtons();
    }

    private void setSelectedTemplate(PalladioTemplate template) {
        this.selectedTemplate = template;
        if (template == null || template.getDescription() == null) {
            this.setDescriptionText("");
        } else {
            this.setDescriptionText(template.getDescription());
        }
    }

    public void setDescriptionText(String text) {
        if (text == null) {
            text = "";
        }
        this.descriptionBrowser.setText(text);
    }

    public PalladioTemplate getSelectedTemplate() {
        return this.selectedTemplate;
    }
}

