/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.allocation.custom.wizard;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.palladiosimulator.editors.sirius.allocation.custom.Activator;
import org.palladiosimulator.editors.sirius.allocation.custom.wizard.ResourceEnvironmentSelectorPage;
import org.palladiosimulator.editors.sirius.allocation.custom.wizard.SystemSelectorPage;
import org.palladiosimulator.editors.sirius.ui.wizard.model.ModelCreationPage;
import org.palladiosimulator.editors.sirius.ui.wizard.model.NewModelWizard;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationFactory;

public class AllocationCreationWizard
extends NewModelWizard {
    private ResourceEnvironmentSelectorPage resourceEnvironmentSelectorpage;
    private SystemSelectorPage systemSelectorPage;

    protected void init(IStructuredSelection selection) {
        String viewpointName = "Allocation";
        this.viewpoint = Activator.getDefault().getViewpoint();
        String ext = Activator.getDefault().getViewpoint().getModelFileExtension();
        this.modelCreationPage = new ModelCreationPage(selection, String.valueOf(viewpointName) + " Creation Wizard", "new" + viewpointName, ext);
        this.representationDescription = Activator.getDefault().getRepresentationDescription();
        String defaultRepresentationName = "new Allocation Diagram";
        this.representationCreationPage.setDefaultRepresentationName(defaultRepresentationName);
        this.resourceEnvironmentSelectorpage = new ResourceEnvironmentSelectorPage();
        this.systemSelectorPage = new SystemSelectorPage();
        this.additionalPages.add(this.resourceEnvironmentSelectorpage);
        this.additionalPages.add(this.systemSelectorPage);
        Allocation obj = AllocationFactory.eINSTANCE.createAllocation();
        obj.setEntityName("New Allocation");
        this.modelObject = obj;
    }

    protected void finish() {
        final Allocation allocation = (Allocation)this.modelObject;
        final Session session = SessionManager.INSTANCE.getSession(this.modelObject);
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        String fileString = this.modelURI.toPlatformString(true);
        Path path = new Path(fileString);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        ArrayList<IFile> list = new ArrayList<IFile>();
        list.add(file);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(domain, "Save Allocation model.", list){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                allocation.setTargetResourceEnvironment_Allocation(AllocationCreationWizard.this.resourceEnvironmentSelectorpage.getSelectedResourceEnvironment(session));
                allocation.setSystem_Allocation(AllocationCreationWizard.this.systemSelectorPage.getSelectedSystem(session));
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            System.out.println("Unable to save allocation model.");
            e.printStackTrace();
        }
    }
}

