/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.assembly.custom.externaljavaactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.ui.PlatformUI;
import org.palladiosimulator.editors.commons.dialogs.selection.PalladioSelectEObjectDialog;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;

public class AddAssemblyContext
implements IExternalJavaAction {
    private static final String NEW_ASSEMBLY_CONTEXT = "newAssemblyContext";
    private static final Collection<EReference> ADDITIONAL_REFERENCES = new ArrayList<EReference>();
    private static final Collection<Object> FILTER_LIST = new ArrayList<Object>();

    static {
        FILTER_LIST.add(Repository.class);
        FILTER_LIST.add(RepositoryComponent.class);
    }

    public boolean canExecute(Collection<? extends EObject> selections) {
        return true;
    }

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        Object parameter = parameters.get(NEW_ASSEMBLY_CONTEXT);
        if (parameter == null || !(parameter instanceof AssemblyContext)) {
            return;
        }
        AssemblyContext assemblyContext = (AssemblyContext)parameter;
        RepositoryComponent repositoryComponent = this.getRepositoryComponent(assemblyContext);
        if (repositoryComponent != null) {
            assemblyContext.setEncapsulatedComponent__AssemblyContext(repositoryComponent);
            assemblyContext.setEntityName("Assembly_" + repositoryComponent.getEntityName());
        }
    }

    private RepositoryComponent getRepositoryComponent(AssemblyContext assemblyContext) {
        PalladioSelectEObjectDialog dialog = new PalladioSelectEObjectDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), FILTER_LIST, ADDITIONAL_REFERENCES, (Object)assemblyContext.eResource().getResourceSet());
        dialog.setProvidedService(RepositoryComponent.class);
        dialog.open();
        if (dialog.getResult() == null) {
            return null;
        }
        if (!(dialog.getResult() instanceof RepositoryComponent)) {
            return null;
        }
        return (RepositoryComponent)dialog.getResult();
    }
}

