/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.custom.editpart;

import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.AbstractEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateGraphicEditPartOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.IEditPartOperation;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.impl.DDiagramElementImpl;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.palladiosimulator.editors.sirius.custom.editpart.RandomVariableEditPart;
import org.palladiosimulator.editors.sirius.custom.editpart.RandomVariableNodeContainerEditPart;
import org.palladiosimulator.pcm.core.CorePackage;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.usagemodel.Loop;

public class RandomVariableEditPartProvider
extends AbstractEditPartProvider {
    public synchronized IGraphicalEditPart createGraphicEditPart(View view) {
        if (view.getElement() instanceof DDiagramElementImpl) {
            DDiagramElementImpl element = (DDiagramElementImpl)view.getElement();
            String name = element.getMapping().getName();
            switch (SiriusVisualIDRegistry.getVisualID((View)view)) {
                case 3010: {
                    return new RandomVariableEditPart(view, this.getExpectedType(name));
                }
                case 3008: {
                    if (!name.equals("LoopIterationCount")) break;
                    RandomVariableNodeContainerEditPart containerEditPart = new RandomVariableNodeContainerEditPart(view, TypeEnum.INT);
                    containerEditPart.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditLoopIterationCount());
                    return containerEditPart;
                }
            }
        }
        return null;
    }

    protected TypeEnum getExpectedType(String mappingName) {
        TypeEnum expectedType = TypeEnum.ANY;
        switch (mappingName) {
            case "GuardedBranchTransition": 
            case "Condition": {
                expectedType = TypeEnum.BOOL;
                break;
            }
            case "ResourceCall": 
            case "InfrastructureCall": {
                expectedType = TypeEnum.INT;
                break;
            }
            case "thinkTime": 
            case "delayTime": 
            case "PassiveResource": 
            case "Latency": 
            case "Throughput": {
                expectedType = TypeEnum.DOUBLE;
            }
        }
        return expectedType;
    }

    public boolean provides(IOperation operation) {
        View view;
        if (operation instanceof CreateGraphicEditPartOperation && (view = ((IEditPartOperation)operation).getView()).getElement() instanceof DDiagramElementImpl) {
            String name;
            DDiagramElementImpl element = (DDiagramElementImpl)view.getElement();
            int visualID = SiriusVisualIDRegistry.getVisualID((View)view);
            if (visualID == 3010 && element.getDiagramElementMapping().getLabelDirectEdit() != null) {
                String inputExpr = element.getDiagramElementMapping().getLabelDirectEdit().getInputLabelExpression();
                String[] splittedInputExpr = inputExpr.split("\\.");
                if (splittedInputExpr.length > 1) {
                    String featureName = splittedInputExpr[1];
                    for (EObject obj : element.getSemanticElements()) {
                        EClassifier type;
                        EStructuralFeature rv = obj.eClass().getEStructuralFeature(featureName);
                        if (rv == null || !(type = rv.getEType()).equals(CorePackage.Literals.PCM_RANDOM_VARIABLE)) continue;
                        return true;
                    }
                }
            } else if (visualID == 3008 && (name = element.getMapping().getName()).equals("LoopIterationCount")) {
                return true;
            }
        }
        return false;
    }

    class DirectEditLoopIterationCount
    extends LabelDirectEditPolicy {
        DirectEditLoopIterationCount() {
        }

        protected org.eclipse.gef.commands.Command getDirectEditCommand(DirectEditRequest edit) {
            final EObject element = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)element);
            final String labelText = (String)edit.getCellEditor().getValue();
            RecordingCommand cmd = new RecordingCommand(domain){

                protected void doExecute() {
                    if (element instanceof DSemanticDecorator) {
                        EObject target = ((DSemanticDecorator)element).getTarget();
                        if (target instanceof LoopAction) {
                            PCMRandomVariable randomVariable = ((LoopAction)target).getIterationCount_LoopAction();
                            randomVariable.setSpecification(labelText);
                        } else if (target instanceof Loop) {
                            PCMRandomVariable randomVariable = ((Loop)target).getLoopIteration_Loop();
                            randomVariable.setSpecification(labelText);
                        }
                    }
                }
            };
            return new ICommandProxy((ICommand)new GMFCommandWrapper(domain, (Command)cmd));
        }
    }
}

