/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.custom.externaljavaactions;

import de.uka.ipd.sdq.stoex.RandomVariable;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.ui.PlatformUI;
import org.palladiosimulator.editors.commons.dialogs.stoex.StochasticExpressionEditDialog;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;

public abstract class OpenExternalStoexEditor<T>
implements IExternalJavaAction {
    private final String actionParameterType = "type";
    private Class<T> type;

    public OpenExternalStoexEditor(Class<T> type) {
        this.type = type;
    }

    public boolean canExecute(Collection<? extends EObject> arg0) {
        return true;
    }

    public void execute(Collection<? extends EObject> arg0, Map<String, Object> arg1) {
        if (arg0.size() != 1) {
            throw new IllegalArgumentException("Multiselection not supported");
        }
        EObject element = arg0.iterator().next();
        T typedElement = this.getTypedElement(element);
        String action = (String)arg1.get("type");
        RandomVariable randVar = this.editStoexAction(action, typedElement);
        if (randVar.getSpecification() == null) {
            this.dialogEmptyRandomVariable(randVar);
        } else {
            this.dialogNotEmptyRandomVariable(randVar);
        }
    }

    protected abstract RandomVariable editStoexAction(String var1, T var2);

    private void dialogEmptyRandomVariable(RandomVariable randVar) {
        RandomVariable copyRand = (RandomVariable)EcoreUtil.copy((EObject)randVar);
        copyRand.setSpecification("0");
        StochasticExpressionEditDialog dialog = this.createDialog(copyRand);
        if (dialog.getReturnCode() == 0) {
            String result = dialog.getResultText();
            randVar.setSpecification(result);
        }
    }

    private void dialogNotEmptyRandomVariable(RandomVariable randVar) {
        StochasticExpressionEditDialog dialog = this.createDialog(randVar);
        if (dialog.getReturnCode() == 0) {
            String result = dialog.getResultText();
            randVar.setSpecification(result);
        }
    }

    private StochasticExpressionEditDialog createDialog(RandomVariable randVar) {
        StochasticExpressionEditDialog dialog = new StochasticExpressionEditDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getExpectedType(randVar), randVar);
        dialog.setInitialExpression(randVar);
        dialog.open();
        return dialog;
    }

    private TypeEnum getExpectedType(RandomVariable rv) {
        TypeEnum expectedType = TypeEnum.ANY;
        if (rv instanceof VariableCharacterisation) {
            expectedType = StochasticExpressionEditDialog.getTypeFromVariableCharacterisation((VariableCharacterisation)((VariableCharacterisation)rv));
        }
        return expectedType;
    }

    private T getTypedElement(EObject o) {
        if (this.type.isInstance(o)) {
            return (T)o;
        }
        throw new IllegalArgumentException("Only " + this.type + " supported");
    }
}

