/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.ui.wizard.project;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.palladiosimulator.architecturaltemplates.AT;
import org.palladiosimulator.architecturaltemplates.Catalog;
import org.palladiosimulator.editors.sirius.ui.wizard.project.DescriptionBox;
import org.palladiosimulator.editors.sirius.ui.wizard.project.TemplateTreeLabelProvider;
import org.palladiosimulator.editors.sirius.ui.wizard.project.TreeContentProvider;

public class NewPalladioTemplateWizardPage
extends WizardPage
implements ISelectionChangedListener {
    protected TreeViewer wizardTreeViewer;
    private DescriptionBox descriptionBrowser;
    private final Set<AT> initiatorATs;
    private final Map<Catalog, List<AT>> allInitiatorATs;
    private AT selectedTemplate;
    private boolean useTemplate;
    private boolean advancedView;
    private SashForm sashForm;
    private Button useTemplateCheckBox;
    private Button advancedViewCheckBox;
    private final String DEFAULT_CATALOG_ID = "_2eRmoCOzEeSLXszsY50NUA";

    public NewPalladioTemplateWizardPage(Set<AT> initiatorATs) {
        super("Architectural Template Selection");
        this.setTitle("Initiator Architectural Template Selection");
        this.setDescription("Select a template to create an initial Palladio model.");
        this.allInitiatorATs = initiatorATs.stream().collect(Collectors.groupingBy(it -> it.getCatalog()));
        this.initiatorATs = this.allInitiatorATs.entrySet().stream().filter(it -> ((Catalog)it.getKey()).getId().equals("_2eRmoCOzEeSLXszsY50NUA")).map(it -> Set.copyOf((Collection)it.getValue())).findAny().orElse(Collections.emptySet());
        this.useTemplate = false;
        this.advancedView = false;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.useTemplateCheckBox = new Button(container, this.useTemplate ? 34 : 32);
        this.useTemplateCheckBox.setText("Create a Palladio project using one of the initiator templates.");
        this.advancedViewCheckBox = new Button(container, this.advancedView ? 34 : 32);
        this.advancedViewCheckBox.setText("Show advanced view (all examples).");
        GridData gd = new GridData();
        this.sashForm = new SashForm(container, 256);
        gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 300;
        this.sashForm.setLayoutData((Object)gd);
        this.useTemplateCheckBox.addSelectionListener(SelectionListener.widgetSelectedAdapter(this::updateEnabledStateOfSelection));
        this.advancedViewCheckBox.addSelectionListener(SelectionListener.widgetSelectedAdapter(it -> this.updateWizardTreeViewerInput()));
        this.wizardTreeViewer = new TreeViewer((Composite)this.sashForm, 2048);
        this.wizardTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.updateWizardTreeViewerInput();
        this.wizardTreeViewer.setLabelProvider((IBaseLabelProvider)new TemplateTreeLabelProvider());
        this.wizardTreeViewer.setComparator(new ViewerComparator());
        this.wizardTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.createDescriptionIn((Composite)this.sashForm);
        this.setControl((Control)container);
        this.updateEnabledStateOfSelection(null);
    }

    private void updateWizardTreeViewerInput() {
        this.wizardTreeViewer.setInput(this.advancedViewCheckBox.getSelection() ? this.allInitiatorATs : this.initiatorATs);
    }

    private void updateEnabledStateOfSelection(SelectionEvent event) {
        this.useTemplate = this.useTemplateCheckBox.getSelection();
        Color color = this.useTemplate ? this.getCurrentDisplayColor(25) : this.getCurrentDisplayColor(38);
        this.sashForm.setEnabled(this.useTemplate);
        this.wizardTreeViewer.getTree().setBackground(color);
        this.descriptionBrowser.formText.setBackground(color);
    }

    private Color getCurrentDisplayColor(int colorId) {
        return Display.getCurrent().getSystemColor(colorId);
    }

    public void createDescriptionIn(Composite composite) {
        this.descriptionBrowser = new DescriptionBox(4);
        this.descriptionBrowser.createControl(composite);
        Control c = this.descriptionBrowser.getControl();
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        c.setLayoutData((Object)gd);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object nextElement;
        this.setErrorMessage(null);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        AT currentTemplateSelection = null;
        Iterator iter = selection.iterator();
        if (iter.hasNext() && (nextElement = iter.next()) instanceof AT) {
            currentTemplateSelection = (AT)nextElement;
        }
        if (currentTemplateSelection == null) {
            this.setSelectedTemplate(null);
            return;
        }
        this.setSelectedTemplate(currentTemplateSelection);
        this.getContainer().updateButtons();
    }

    private void setSelectedTemplate(AT template) {
        this.selectedTemplate = template;
        if (template == null || template.getDocumentation() == null) {
            this.setDescriptionText("");
        } else {
            this.setDescriptionText(template.getDocumentation());
        }
    }

    public void setDescriptionText(String text) {
        if (text == null) {
            text = "";
        }
        this.descriptionBrowser.setText(text);
    }

    public AT getSelectedTemplate() {
        return this.selectedTemplate;
    }

    public boolean getUseTemplate() {
        return this.useTemplate;
    }
}

