/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.promise.PromiseImpl;

final class FailedPromiseImpl<T>
extends PromiseImpl<T> {
    private final Throwable fail;

    FailedPromiseImpl(Throwable fail, PromiseFactory factory) {
        super(factory);
        this.fail = Objects.requireNonNull(fail);
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T getValue() throws InvocationTargetException {
        throw new InvocationTargetException(this.fail);
    }

    @Override
    public Throwable getFailure() {
        return this.fail;
    }

    @Override
    PromiseImpl.Result<T> collect() {
        return new PromiseImpl.Result(this.fail);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[failed: " + this.fail + "]";
    }
}

