/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.engine.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cbi.p2repo.aggregator.Aggregation;
import org.eclipse.cbi.p2repo.aggregator.AggregatorFactory;
import org.eclipse.cbi.p2repo.aggregator.Architecture;
import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.cbi.p2repo.aggregator.MavenItem;
import org.eclipse.cbi.p2repo.aggregator.MavenMapping;
import org.eclipse.cbi.p2repo.aggregator.OperatingSystem;
import org.eclipse.cbi.p2repo.aggregator.StatusCode;
import org.eclipse.cbi.p2repo.aggregator.VersionFormat;
import org.eclipse.cbi.p2repo.aggregator.WindowSystem;
import org.eclipse.cbi.p2repo.aggregator.engine.maven.InstallableUnitOverrider;
import org.eclipse.cbi.p2repo.aggregator.util.InstallableUnitUtils;
import org.eclipse.cbi.p2repo.p2.maven.POM;
import org.eclipse.cbi.p2repo.p2.maven.pom.DependenciesType;
import org.eclipse.cbi.p2repo.p2.maven.pom.Dependency;
import org.eclipse.cbi.p2repo.p2.maven.pom.License;
import org.eclipse.cbi.p2repo.p2.maven.pom.LicensesType;
import org.eclipse.cbi.p2repo.p2.maven.pom.Model;
import org.eclipse.cbi.p2repo.p2.maven.pom.Parent;
import org.eclipse.cbi.p2repo.p2.maven.pom.PomFactory;
import org.eclipse.cbi.p2repo.p2.maven.util.VersionUtil;
import org.eclipse.cbi.p2repo.util.ExceptionUtils;
import org.eclipse.cbi.p2repo.util.LogUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;

public class InstallableUnitMapping
implements IInstallableUnit {
    private static final String GENERIC_PLATFORM_SUFFIX = ".${osgi.platform}";
    private static final Set<String> KNOWN_OSGI_WS;
    private static final Set<String> KNOWN_OSGI_OS;
    private static final Set<String> KNOWN_OSGI_ARCH;
    private static final Version DUMMY_VERSION;
    private Type type;
    private IInstallableUnit installableUnit;
    private List<MavenMapping> mappings;
    private MavenItem mapped;
    private InstallableUnitMapping parent;
    private List<InstallableUnitMapping> children = new ArrayList<InstallableUnitMapping>();
    private List<InstallableUnitMapping> siblings = new ArrayList<InstallableUnitMapping>();
    private boolean transientFlag;
    private IArtifactKey mainArtifact;
    private Contribution contribution;
    private VersionFormat versionFormat;
    private int mavenBuildNumber;
    private boolean hasSources;

    static {
        HashSet<String> values = new HashSet<String>();
        WindowSystem[] windowSystemArray = WindowSystem.values();
        int n = windowSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            WindowSystem ws = windowSystemArray[n2];
            values.add(ws.getLiteral());
            ++n2;
        }
        KNOWN_OSGI_WS = Collections.unmodifiableSet(values);
        values = new HashSet();
        windowSystemArray = OperatingSystem.values();
        n = windowSystemArray.length;
        n2 = 0;
        while (n2 < n) {
            WindowSystem os = windowSystemArray[n2];
            values.add(os.getLiteral());
            ++n2;
        }
        KNOWN_OSGI_OS = Collections.unmodifiableSet(values);
        values = new HashSet();
        windowSystemArray = Architecture.values();
        n = windowSystemArray.length;
        n2 = 0;
        while (n2 < n) {
            WindowSystem arch = windowSystemArray[n2];
            values.add(arch.getLiteral());
            ++n2;
        }
        KNOWN_OSGI_ARCH = Collections.unmodifiableSet(values);
        DUMMY_VERSION = Version.parseVersion((String)"1");
    }

    public InstallableUnitMapping(Contribution contribution, IInstallableUnit iu) {
        this(contribution, iu, Collections.emptyList());
    }

    public InstallableUnitMapping(Contribution contribution, IInstallableUnit iu, List<MavenMapping> mappings) {
        this.contribution = contribution;
        this.mappings = new ArrayList<MavenMapping>(mappings.size() + 1);
        this.mappings.addAll(mappings);
        this.mappings.add(MavenMapping.DEFAULT_MAPPING);
        for (MavenMapping mapping : mappings) {
            if (mapping.getStatus().getCode() == StatusCode.OK) continue;
            throw new RuntimeException("Invalid maven mapping: " + mapping.toString());
        }
        switch (iu.getArtifacts().size()) {
            case 1: {
                this.mainArtifact = (IArtifactKey)iu.getArtifacts().iterator().next();
            }
            case 0: {
                this.type = Type.IU;
                this.installableUnit = iu;
                break;
            }
            default: {
                InstallableUnitOverrider proxy = new InstallableUnitOverrider(iu);
                ArrayList<IRequirement> dependencies = new ArrayList<IRequirement>(iu.getArtifacts().size());
                int idx = 0;
                for (IArtifactKey artifact : iu.getArtifacts()) {
                    String genId = String.valueOf(artifact.getId()) + ".artifact-" + (idx + 1);
                    dependencies.add((IRequirement)new RequiredCapability("org.eclipse.equinox.p2.iu", genId, new VersionRange(iu.getVersion(), true, iu.getVersion(), true), null, false, false));
                    InstallableUnitOverrider sibling = new InstallableUnitOverrider(iu);
                    sibling.overrideId(genId);
                    sibling.overrideArtifacts(Collections.singletonList(artifact));
                    this.siblings.add(new InstallableUnitMapping(contribution, sibling));
                }
                proxy.overrideRequirements(dependencies);
                proxy.overrideArtifacts(Collections.emptyList());
                this.installableUnit = proxy;
            }
        }
        Aggregation aggregation = (Aggregation)((EObject)contribution).eContainer().eContainer();
        this.versionFormat = aggregation.getVersionFormat();
        this.mavenBuildNumber = aggregation.getMavenBuildNumber();
    }

    public InstallableUnitMapping(String name) {
        String groupId = name;
        if (groupId == null) {
            groupId = "_top";
        }
        String artifactId = name == null ? "_common" : "_group-common";
        this.type = name == null ? Type.TOP : Type.GROUP;
        InstallableUnit installableUnit = new InstallableUnit();
        installableUnit.setId(artifactId);
        installableUnit.setVersion(DUMMY_VERSION);
        this.installableUnit = installableUnit;
        this.mapped = AggregatorFactory.eINSTANCE.createMavenItem();
        this.mapped.setGroupId(groupId);
        this.mapped.setArtifactId(artifactId);
    }

    public InstallableUnitMapping(VersionFormat versionFormat) {
        this((String)null);
        this.versionFormat = versionFormat;
    }

    public POM asPOM() throws CoreException {
        ICopyright iuCopyright;
        Collection<IRequirement> requirements;
        POM pom = new POM();
        Model model = pom.getProject();
        if (this.parent != null && !this.parent.isTransient()) {
            Parent newParent = PomFactory.eINSTANCE.createParent();
            newParent.setGroupId(this.parent.map().getGroupId());
            newParent.setArtifactId(this.parent.map().getArtifactId());
            newParent.setVersion(this.parent.getVersionString(false, -1));
            model.setParent(newParent);
        }
        model.setModelVersion("4.0.0");
        model.setGroupId(this.map().getGroupId());
        model.setArtifactId(this.map().getArtifactId());
        if (this.getMainArtifact() == null) {
            model.setPackaging("pom");
        }
        if (this.getVersion() != null && !this.getVersion().equals(Version.emptyVersion)) {
            model.setVersion(this.getVersionString(false, -1));
        }
        if ((requirements = this.getRequirements()).size() > 0) {
            DependenciesType dependencies = PomFactory.eINSTANCE.createDependenciesType();
            boolean hasPlatformFragmentDependency = false;
            for (IRequirement req : requirements) {
                IRequiredCapability cap;
                if (!(req instanceof IRequiredCapability) || !"org.eclipse.equinox.p2.iu".equals((cap = (IRequiredCapability)req).getNamespace()) && !"osgi.bundle".equals(cap.getNamespace())) continue;
                Dependency dependency = PomFactory.eINSTANCE.createDependency();
                MavenItem dependencyMapping = this.map(cap.getName(), this.mappings);
                dependency.setGroupId(dependencyMapping.getGroupId());
                String artifactId = dependencyMapping.getArtifactId();
                String generifiedId = this.generifyPlatformDependency(artifactId, (IMatchExpression<IInstallableUnit>)req.getFilter());
                if (generifiedId != null) {
                    if (hasPlatformFragmentDependency) continue;
                    hasPlatformFragmentDependency = true;
                    artifactId = generifiedId;
                }
                dependency.setArtifactId(artifactId);
                dependencies.getDependency().add((Object)dependency);
                if (cap.getRange() != null && !cap.getRange().equals((Object)VersionRange.emptyRange)) {
                    StringBuilder versionRangeString = new StringBuilder();
                    Version low = cap.getRange().getMinimum();
                    Version high = cap.getRange().getMaximum();
                    if (cap.getRange().getIncludeMinimum() && Version.MAX_VERSION.equals(high)) {
                        versionRangeString.append("[").append(this.getVersionStringForDependency(dependencyMapping, low)).append(",)");
                    } else {
                        versionRangeString.append(cap.getRange().getIncludeMinimum() ? (char)'[' : '(');
                        versionRangeString.append(this.getVersionStringForDependency(dependencyMapping, low));
                        versionRangeString.append(',');
                        versionRangeString.append(this.getVersionStringForDependency(dependencyMapping, high));
                        versionRangeString.append(cap.getRange().getIncludeMaximum() ? (char)']' : ')');
                    }
                    dependency.setVersion(versionRangeString.toString());
                } else {
                    dependency.setVersion("[0.0,)");
                }
                if (cap.getMin() != 0) continue;
                dependency.setOptional(true);
            }
            if (dependencies.getDependency().size() > 0) {
                model.setDependencies(dependencies);
            }
        }
        HashMap<String, String> iuProperties = new HashMap<String, String>(this.installableUnit.getProperties());
        String name = this.extractProperty(iuProperties, "org.eclipse.equinox.p2.name");
        String description = this.extractProperty(iuProperties, "org.eclipse.equinox.p2.description");
        if (name != null || description != null) {
            if (name != null) {
                if (description != null) {
                    name = String.valueOf(name) + "\n\n";
                }
            } else {
                name = "";
            }
            if (description == null) {
                description = "";
            }
            model.setDescription(String.valueOf(name) + description);
        }
        LicensesType licenses = PomFactory.eINSTANCE.createLicensesType();
        Collection iuLicenses = this.installableUnit.getLicenses();
        if (iuLicenses.size() > 0) {
            for (ILicense iuLicense : iuLicenses) {
                License license = PomFactory.eINSTANCE.createLicense();
                boolean licenseSet = false;
                if (iuLicense.getLocation() != null) {
                    licenseSet = true;
                    license.setUrl(iuLicense.getLocation().toString());
                }
                if (iuLicense.getBody() != null) {
                    licenseSet = true;
                    license.setComments(iuLicense.getBody());
                }
                if (!licenseSet) continue;
                licenses.getLicense().add((Object)license);
            }
        }
        if ((iuCopyright = this.installableUnit.getCopyright()) != null) {
            License copyright = PomFactory.eINSTANCE.createLicense();
            boolean copyrightSet = false;
            if (iuCopyright.getLocation() != null) {
                copyrightSet = true;
                copyright.setUrl(iuCopyright.getLocation().toString());
            }
            if (iuCopyright.getBody() != null) {
                copyrightSet = true;
                copyright.setComments(iuCopyright.getBody());
            }
            if (copyrightSet) {
                licenses.getLicense().add((Object)copyright);
            }
        }
        if (licenses.getLicense().size() > 0) {
            model.setLicenses(licenses);
        }
        return pom;
    }

    public int compareTo(IInstallableUnit other) {
        return this.installableUnit.compareTo((Object)other);
    }

    private String extractProperty(Map<String, String> iuProperties, String key) {
        String localizedKey;
        String localizedValue;
        String value = iuProperties.remove(key);
        if (value != null && value.startsWith("%") && (localizedValue = iuProperties.remove(localizedKey = "df_LT." + value.substring(1))) != null) {
            value = localizedValue;
        }
        return this.trimOrNull(value);
    }

    private String generifyPlatformDependency(String artifactId, IMatchExpression<IInstallableUnit> filter) {
        if (artifactId == null || filter == null) {
            return null;
        }
        String[] tokens = artifactId.split("\\.");
        if (tokens.length < 4) {
            return null;
        }
        HashMap<String, String> declared = new HashMap<String, String>();
        int end = artifactId.length();
        int platformStart = tokens.length - 3;
        String token = tokens[platformStart];
        if (!KNOWN_OSGI_WS.contains(token)) {
            return null;
        }
        declared.put("osgi.ws", token);
        end -= token.length() + 1;
        token = tokens[platformStart + 1];
        if (!KNOWN_OSGI_OS.contains(token)) {
            return null;
        }
        declared.put("osgi.os", token);
        end -= token.length() + 1;
        token = tokens[platformStart + 2];
        if (!KNOWN_OSGI_ARCH.contains(token)) {
            return null;
        }
        declared.put("osgi.arch", token);
        end -= token.length() + 1;
        if (!this.matchesFilter(filter, declared)) {
            return null;
        }
        return String.valueOf(artifactId.substring(0, end)) + GENERIC_PLATFORM_SUFFIX;
    }

    private String getArtifactFileName() throws CoreException {
        return this.getFileName(null);
    }

    public Collection<IArtifactKey> getArtifacts() {
        return this.installableUnit.getArtifacts();
    }

    public List<InstallableUnitMapping> getChildren() {
        return this.children;
    }

    public final Contribution getContribution() {
        return this.contribution;
    }

    public ICopyright getCopyright() {
        return this.installableUnit.getCopyright();
    }

    public ICopyright getCopyright(String locale) {
        return this.installableUnit.getCopyright(locale);
    }

    private String getFileName(String extension) throws CoreException {
        String fileId = this.mapped.getArtifactId();
        StringBuilder fileName = new StringBuilder(fileId);
        fileName.append('-');
        fileName.append(this.getVersionString(true, this.mavenBuildNumber));
        if (this.isSourceArtifact()) {
            fileName.append('-').append(this.mapped.getClassifier());
        }
        if (extension == null) {
            if (this.getMainArtifact() == null || !"binary".equals(this.getMainArtifact().getClassifier())) {
                fileName.append(".jar");
            }
        } else {
            fileName.append('.');
            fileName.append(extension);
        }
        return fileName.toString();
    }

    public IMatchExpression<IInstallableUnit> getFilter() {
        return this.installableUnit.getFilter();
    }

    public Collection<IInstallableUnitFragment> getFragments() {
        return this.installableUnit.getFragments();
    }

    public String getId() {
        return this.installableUnit.getId();
    }

    public Collection<ILicense> getLicenses() {
        return this.installableUnit.getLicenses();
    }

    public Collection<ILicense> getLicenses(String locale) {
        return this.installableUnit.getLicenses(locale);
    }

    public IArtifactKey getMainArtifact() {
        return this.mainArtifact;
    }

    public Version getMappedVersion() {
        String mappedVersion;
        if (this.mapped != null && (mappedVersion = this.mapped.getMappedVersion()) != null) {
            return VersionUtil.mappedVersion((String)mappedVersion, (VersionFormat)this.versionFormat);
        }
        return this.installableUnit.getVersion();
    }

    public Collection<IRequirement> getMetaRequirements() {
        return this.installableUnit.getMetaRequirements();
    }

    public InstallableUnitMapping getParent() {
        return this.parent;
    }

    public String getPomName() throws CoreException {
        return this.getFileName("pom");
    }

    public Map<String, String> getProperties() {
        return this.installableUnit.getProperties();
    }

    public String getProperty(String key) {
        return this.installableUnit.getProperty(key);
    }

    public String getProperty(String key, String locale) {
        return this.installableUnit.getProperty(key, locale);
    }

    public Collection<IProvidedCapability> getProvidedCapabilities() {
        return this.installableUnit.getProvidedCapabilities();
    }

    public String getRelativeFullPath() throws CoreException {
        return String.valueOf(this.getRelativePath()) + "/" + this.getArtifactFileName();
    }

    public String getRelativePath() throws CoreException {
        String artifactId = this.map().getArtifactId();
        String versionPath = this.getVersionString(false, -1);
        return String.valueOf(this.map().getGroupId().replace('.', '/')) + "/" + artifactId + "/" + versionPath;
    }

    public Collection<IRequirement> getRequirements() {
        if (this.parent != null) {
            ArrayList<IRequirement> myList = new ArrayList<IRequirement>();
            Collection parentList = this.parent.installableUnit.getRequirements();
            for (IRequirement my : this.installableUnit.getRequirements()) {
                if (parentList.contains(my)) continue;
                myList.add(my);
            }
            return myList;
        }
        return this.installableUnit.getRequirements();
    }

    public List<InstallableUnitMapping> getSiblings() {
        return this.siblings;
    }

    public Collection<ITouchpointData> getTouchpointData() {
        return this.installableUnit.getTouchpointData();
    }

    public ITouchpointType getTouchpointType() {
        return this.installableUnit.getTouchpointType();
    }

    public Type getType() {
        return this.type;
    }

    public IUpdateDescriptor getUpdateDescriptor() {
        return this.installableUnit.getUpdateDescriptor();
    }

    public Version getVersion() {
        return this.installableUnit.getVersion();
    }

    public VersionFormat getVersionFormat() {
        return this.versionFormat;
    }

    public String getVersionString(boolean fineGrained, int mavenBuildNumber) {
        if (this.mapped != null && this.mapped.getMappedVersion() != null) {
            String mappedVersion = this.mapped.getMappedVersion();
            if (!fineGrained && this.versionFormat == VersionFormat.MAVEN_SNAPSHOT) {
                return VersionUtil.versionAsSnapshot((String)mappedVersion);
            }
            return mappedVersion;
        }
        return VersionUtil.getVersionString((Version)this.getVersion(), (VersionFormat)this.versionFormat, (boolean)fineGrained, (int)mavenBuildNumber);
    }

    public String getVersionStringForDependency(MavenItem dependencyMapping, Version dependencyVersion) {
        String mappedVersion;
        MavenMapping mavenMapping = dependencyMapping.getMavenMapping();
        if (mavenMapping != null && (mappedVersion = mavenMapping.mapVersion(dependencyVersion)) != null) {
            return mappedVersion;
        }
        return VersionUtil.getVersionString((Version)dependencyVersion, (VersionFormat)this.versionFormat, (boolean)false, (int)-1);
    }

    public boolean isResolved() {
        return this.installableUnit.isResolved();
    }

    public boolean isSingleton() {
        return this.installableUnit.isSingleton();
    }

    public boolean isSourceArtifact() {
        if (!InstallableUnitUtils.isSourceBundle((IInstallableUnit)this.installableUnit)) {
            return false;
        }
        try {
            return this.map().isSources();
        }
        catch (CoreException e) {
            LogUtils.error((Throwable)e, (String)"Failed to map artifact {0}", (Object[])new Object[]{this.getId()});
            return false;
        }
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public MavenItem map() throws CoreException {
        if (this.mapped != null) {
            return this.mapped;
        }
        this.mapped = this.map(this.getId(), this.mappings);
        if (this.mapped != null && this.versionFormat != VersionFormat.MAVEN_SNAPSHOT) {
            if (this.mapped.getMavenMapping().isSnapshot()) {
                this.versionFormat = VersionFormat.MAVEN_SNAPSHOT;
            } else {
                String mappedVersion = this.mapped.getMappedVersion();
                if (mappedVersion != null && mappedVersion.contains("-SNAPSHOT")) {
                    this.versionFormat = VersionFormat.MAVEN_SNAPSHOT;
                }
            }
        }
        return this.mapped;
    }

    private MavenItem map(String id, List<MavenMapping> mappings) throws CoreException {
        MavenItem item = null;
        for (MavenMapping mapping : mappings) {
            item = mapping.map(id, this.getVersion());
            if (item == null) continue;
            return item;
        }
        StringBuilder mappingDescriptor = new StringBuilder();
        boolean first = true;
        for (MavenMapping mapping : mappings) {
            if (first) {
                first = false;
            } else {
                mappingDescriptor.append(',');
            }
            mappingDescriptor.append(mapping.toString());
        }
        throw ExceptionUtils.fromMessage((String)"Unable to map IU to maven artifact: id=%s, mappings=%s", (Object[])new Object[]{id, mappingDescriptor.toString()});
    }

    private boolean matchesFilter(IMatchExpression<IInstallableUnit> filter, Map<String, String> map) {
        Object[] objectArray = filter.getParameters();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IFilterExpression) {
                return ((IFilterExpression)object).match(map);
            }
            ++n2;
        }
        return false;
    }

    public boolean satisfies(IRequiredCapability candidate) {
        return this.installableUnit.satisfies((IRequirement)candidate);
    }

    public boolean satisfies(IRequirement candidate) {
        return this.installableUnit.satisfies(candidate);
    }

    public void setParent(InstallableUnitMapping parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        this.parent.children.add(this);
    }

    public void setTransient(boolean isTransient) {
        this.transientFlag = isTransient;
    }

    private String trimOrNull(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    public IInstallableUnit unresolved() {
        return this.installableUnit.unresolved();
    }

    public void setHasSources(boolean flag) {
        this.hasSources = flag;
    }

    public boolean hasSources() {
        return this.hasSources;
    }

    public static enum Type {
        TOP,
        GROUP,
        IU,
        PROXY;

    }
}

