/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.engine.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cbi.p2repo.aggregator.Aggregation;
import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.cbi.p2repo.aggregator.MavenItem;
import org.eclipse.cbi.p2repo.aggregator.VersionFormat;
import org.eclipse.cbi.p2repo.aggregator.engine.maven.InstallableUnitMapping;
import org.eclipse.cbi.p2repo.aggregator.engine.maven.MavenRepositoryHelper;
import org.eclipse.cbi.p2repo.p2.maven.MavenMetadata;
import org.eclipse.cbi.p2repo.p2.maven.metadata.MetaData;
import org.eclipse.cbi.p2repo.p2.maven.metadata.MetadataFactory;
import org.eclipse.cbi.p2repo.p2.maven.metadata.Snapshot;
import org.eclipse.cbi.p2repo.p2.maven.metadata.SnapshotVersion;
import org.eclipse.cbi.p2repo.p2.maven.metadata.SnapshotVersionsType;
import org.eclipse.cbi.p2repo.p2.maven.metadata.Versioning;
import org.eclipse.cbi.p2repo.p2.maven.metadata.VersionsType;
import org.eclipse.cbi.p2repo.p2.maven.util.DigestUtil;
import org.eclipse.cbi.p2repo.p2.maven.util.VersionUtil;
import org.eclipse.cbi.p2repo.p2.util.IUUtils;
import org.eclipse.cbi.p2repo.util.ExceptionUtils;
import org.eclipse.cbi.p2repo.util.LogUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.internal.p2.metadata.BasicVersion;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;

public class MavenManager {
    private static void addMappingRule(List<String[]> mappingRulesList, InstallableUnitMapping iu) throws CoreException {
        if (iu.getMainArtifact() != null) {
            IArtifactKey artifact = iu.getMainArtifact();
            mappingRulesList.add(new String[]{"(& (classifier=" + IUUtils.encodeFilterValue((String)artifact.getClassifier()) + ")(id=" + IUUtils.encodeFilterValue((String)artifact.getId()) + ")(version=" + IUUtils.encodeFilterValue((String)iu.getVersion().toString()) + "))", "${repoUrl}/" + iu.getRelativeFullPath()});
        }
    }

    private static URI createArtifactURI(URI root, InstallableUnitMapping iu) throws CoreException {
        if (iu.getMainArtifact() != null) {
            return URI.createURI((String)(String.valueOf(root.toString()) + "/" + iu.getRelativeFullPath()));
        }
        return null;
    }

    private static void createCheckSum(URI fileUri, URIConverter uriConverter, MessageDigest[] digests) throws CoreException {
        InputStream is = null;
        PrintWriter digestWriter = null;
        try {
            try {
                int n;
                MessageDigest[] messageDigestArray;
                int read;
                is = uriConverter.createInputStream(fileUri);
                MessageDigest[] messageDigestArray2 = digests;
                int n2 = digests.length;
                int n3 = 0;
                while (n3 < n2) {
                    MessageDigest digest = messageDigestArray2[n3];
                    digest.reset();
                    ++n3;
                }
                byte[] buffer = new byte[4096];
                while ((read = is.read(buffer)) != -1) {
                    messageDigestArray = digests;
                    n = digests.length;
                    int n4 = 0;
                    while (n4 < n) {
                        MessageDigest digest = messageDigestArray[n4];
                        digest.update(buffer, 0, read);
                        ++n4;
                    }
                }
                is.close();
                messageDigestArray = digests;
                n = digests.length;
                int n5 = 0;
                while (n5 < n) {
                    MessageDigest digest = messageDigestArray[n5];
                    byte[] result = digest.digest();
                    URI digestUri = URI.createURI((String)(String.valueOf(fileUri.toString()) + "." + digest.getAlgorithm().toLowerCase()));
                    digestWriter = new PrintWriter(uriConverter.createOutputStream(digestUri));
                    byte[] byArray = result;
                    int n6 = result.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        byte b = byArray[n7];
                        digestWriter.printf("%02x", b);
                        ++n7;
                    }
                    digestWriter.close();
                    ++n5;
                }
            }
            catch (IOException e) {
                throw ExceptionUtils.fromMessage((Throwable)e, (String)"Error creating digest for %s", (Object[])new Object[]{fileUri.toString()});
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (digestWriter != null) {
                digestWriter.close();
            }
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (digestWriter != null) {
            digestWriter.close();
        }
    }

    public static MavenRepositoryHelper createMavenStructure(List<InstallableUnitMapping> ius, Aggregation aggregation) throws CoreException {
        ArrayList<InstallableUnitMapping> group;
        ArrayList<String[]> mappingRulesList = new ArrayList<String[]>();
        mappingRulesList.add(new String[]{"(& (classifier=osgi.bundle) (format=packed))", "${repoUrl}/p2.packed/plugins/${id}_${version}.jar.pack.gz"});
        mappingRulesList.add(new String[]{"(& (classifier=org.eclipse.update.feature) (format=packed))", "${repoUrl}/p2.packed/features/${id}_${version}.jar.pack.gz"});
        HashMap<String, ArrayList<InstallableUnitMapping>> groupMap = new HashMap<String, ArrayList<InstallableUnitMapping>>();
        for (InstallableUnitMapping iu : ius) {
            String groupId = iu.map().getGroupId();
            group = (ArrayList<InstallableUnitMapping>)groupMap.get(groupId);
            if (group == null) {
                group = new ArrayList<InstallableUnitMapping>();
                groupMap.put(groupId, group);
            }
            group.add(iu);
        }
        InstallableUnitMapping top = new InstallableUnitMapping(aggregation.getVersionFormat());
        top.setTransient(true);
        MavenManager.addMappingRule(mappingRulesList, top);
        for (Map.Entry entry : groupMap.entrySet()) {
            group = new InstallableUnitMapping((String)entry.getKey());
            MavenManager.addMappingRule(mappingRulesList, (InstallableUnitMapping)((Object)group));
            for (InstallableUnitMapping iu : (List)entry.getValue()) {
                MavenManager.addMappingRule(mappingRulesList, iu);
                iu.setParent((InstallableUnitMapping)((Object)group));
                for (InstallableUnitMapping sibling : iu.getSiblings()) {
                    MavenManager.addMappingRule(mappingRulesList, sibling);
                    sibling.setParent((InstallableUnitMapping)((Object)group));
                }
            }
            ((InstallableUnitMapping)((Object)group)).setParent(top);
            ((InstallableUnitMapping)((Object)group)).setTransient(true);
        }
        return new MavenRepositoryHelper(top, (String[][])mappingRulesList.toArray((T[])new String[mappingRulesList.size()][]));
    }

    private static URI createPomURI(URI root, InstallableUnitMapping iu) throws CoreException {
        return URI.createURI((String)(String.valueOf(root.toString()) + "/" + iu.getRelativePath() + "/" + iu.getPomName()));
    }

    private static URI createXmlURI(URI root, MavenMetadataHelper md) throws CoreException {
        return URI.createURI((String)(String.valueOf(root.toString()) + "/" + md.getRelativePath() + "/maven-metadata.xml"));
    }

    private static URI createSnapshotXmlURI(URI root, MavenMetadataHelper md, Version version) throws CoreException {
        String versionDir = VersionUtil.getVersionString((Version)version, (VersionFormat)VersionFormat.MAVEN_SNAPSHOT, (boolean)false, (int)-1);
        return URI.createURI((String)(String.valueOf(root.toString()) + "/" + md.getRelativePath() + "/" + versionDir + "/maven-metadata.xml"));
    }

    public static void saveMetadata(URI root, InstallableUnitMapping iu, Map<Contribution, List<String>> errors, int buildNumber) throws CoreException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URIConverter uriConverter = resourceSet.getURIConverter();
        HashMap<String, MavenMetadataHelper> metadataCollector = new HashMap<String, MavenMetadataHelper>();
        MavenManager.savePOMs(root, iu, uriConverter, DigestUtil.MESSAGE_DIGESTERS, metadataCollector, errors);
        MavenManager.saveXMLs(root, uriConverter, DigestUtil.MESSAGE_DIGESTERS, metadataCollector, buildNumber);
    }

    private static void savePOMs(URI root, InstallableUnitMapping iu, URIConverter uriConverter, MessageDigest[] digests, Map<String, MavenMetadataHelper> metadataCollector, Map<Contribution, List<String>> errors) throws CoreException {
        if (!iu.isTransient()) {
            URI artifactUri;
            boolean isSource = iu.isSourceArtifact();
            if (!isSource) {
                URI pomUri = MavenManager.createPomURI(root, iu);
                iu.asPOM().save(pomUri);
                MavenManager.createCheckSum(pomUri, uriConverter, digests);
            }
            if ((artifactUri = MavenManager.createArtifactURI(root, iu)) != null) {
                try {
                    MavenManager.createCheckSum(artifactUri, uriConverter, digests);
                }
                catch (CoreException e) {
                    Contribution contrib = iu.getContribution();
                    List<String> contribErrors = errors.get(contrib);
                    if (contribErrors == null) {
                        contribErrors = new ArrayList<String>();
                        errors.put(contrib, contribErrors);
                    }
                    StringBuilder msgBuilder = new StringBuilder(e.getMessage());
                    if (e.getCause() != null) {
                        msgBuilder.append(':');
                        msgBuilder.append(' ');
                        msgBuilder.append(e.getCause().toString());
                    }
                    String msg = msgBuilder.toString();
                    LogUtils.error((String)msg, (Object[])new Object[0]);
                    contribErrors.add(msg);
                }
            }
            if (isSource) {
                return;
            }
            String key = String.valueOf(iu.map().getGroupId()) + "/" + iu.map().getArtifactId();
            MavenMetadataHelper md = metadataCollector.get(key);
            if (md == null) {
                md = new MavenMetadataHelper(iu.map().getGroupId(), iu.map().getArtifactId(), iu.getVersionFormat(), iu.hasSources());
                metadataCollector.put(key, md);
            }
            md.addVersion(iu.getMappedVersion(), iu.getVersionFormat() == VersionFormat.MAVEN_SNAPSHOT);
        }
        for (InstallableUnitMapping child : iu.getChildren()) {
            if (!child.isSourceArtifact()) continue;
            MavenManager.markSiblingHasSources(child, iu.getChildren());
        }
        for (InstallableUnitMapping child : iu.getChildren()) {
            MavenManager.savePOMs(root, child, uriConverter, digests, metadataCollector, errors);
        }
    }

    public static void markSiblingHasSources(InstallableUnitMapping sourcesIU, List<InstallableUnitMapping> siblings) throws CoreException {
        MavenItem sourcesItem = sourcesIU.map();
        for (InstallableUnitMapping siblingMapping : siblings) {
            MavenItem sibling;
            if (siblingMapping == sourcesIU || !(sibling = siblingMapping.map()).getGroupId().equals(sourcesItem.getGroupId()) || !sibling.getArtifactId().equals(sourcesItem.getArtifactId()) || sibling.getClassifier() != null) continue;
            siblingMapping.setHasSources(true);
            break;
        }
    }

    private static void saveXMLs(URI root, URIConverter uriConverter, MessageDigest[] digests, Map<String, MavenMetadataHelper> metadataCollector, int buildNumber) throws CoreException {
        String timestamp = String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", new Date());
        String timestampDot = String.format("%1$tY%1$tm%1$td.%1$tH%1$tM%1$tS", new Date());
        for (MavenMetadataHelper mdh : metadataCollector.values()) {
            mdh.finalizeMetadata();
            VersionFormat versionFormat = mdh.getVersionFormat();
            MavenMetadata mdConainter = new MavenMetadata();
            MetaData md = mdConainter.getMetaData();
            md.setGroupId(mdh.getGroupId());
            md.setArtifactId(mdh.getArtifactId());
            Versioning versioning = MetadataFactory.eINSTANCE.createVersioning();
            md.setVersioning(versioning);
            versioning.setLastUpdated(timestamp);
            Version release = mdh.getRelease();
            if (release != null) {
                versioning.setRelease(VersionUtil.getVersionString((Version)release, (VersionFormat)versionFormat, (boolean)false, (int)-1));
            }
            versioning.setLatest(VersionUtil.getVersionString((Version)mdh.getLatest(), (VersionFormat)versionFormat, (boolean)false, (int)-1));
            VersionsType versions = MetadataFactory.eINSTANCE.createVersionsType();
            versioning.setVersions(versions);
            EList versionList = versions.getVersion();
            mdh.getVersions().stream().map(v -> VersionUtil.getVersionString((Version)v, (VersionFormat)versionFormat, (boolean)false, (int)-1)).distinct().forEach(((List)versionList)::add);
            URI xmlUri = MavenManager.createXmlURI(root, mdh);
            mdConainter.save(xmlUri);
            MavenManager.createCheckSum(xmlUri, uriConverter, digests);
            if (versionFormat != VersionFormat.MAVEN_SNAPSHOT) continue;
            for (Version version : mdh.getVersions()) {
                mdConainter = new MavenMetadata();
                md = mdConainter.getMetaData();
                md.setGroupId(mdh.getGroupId());
                md.setArtifactId(mdh.getArtifactId());
                String versionString = VersionUtil.getVersionString((Version)version, (VersionFormat)versionFormat, (boolean)false, (int)-1);
                md.setVersion(versionString);
                versioning = MetadataFactory.eINSTANCE.createVersioning();
                md.setVersioning(versioning);
                versioning.setLastUpdated(timestamp);
                Snapshot snapshot = MetadataFactory.eINSTANCE.createSnapshot();
                versioning.setSnapshot(snapshot);
                snapshot.setTimestamp(timestampDot);
                snapshot.setBuildNumber(buildNumber);
                SnapshotVersionsType snapVersions = MetadataFactory.eINSTANCE.createSnapshotVersionsType();
                versioning.setSnapshotVersions(snapVersions);
                EList snapVersionList = snapVersions.getSnapshotVersion();
                String snapshotVersion = VersionUtil.getVersionString((Version)version, (VersionFormat)VersionFormat.MAVEN_SNAPSHOT, (boolean)true, (int)buildNumber);
                snapVersionList.add((Object)MavenManager.createSnapshotVersion(null, "jar", snapshotVersion, timestamp));
                snapVersionList.add((Object)MavenManager.createSnapshotVersion(null, "pom", snapshotVersion, timestamp));
                if (mdh.hasSources()) {
                    snapVersionList.add((Object)MavenManager.createSnapshotVersion("sources", "jar", snapshotVersion, timestamp));
                }
                xmlUri = MavenManager.createSnapshotXmlURI(root, mdh, version);
                mdConainter.save(xmlUri);
                MavenManager.createCheckSum(xmlUri, uriConverter, digests);
            }
        }
    }

    public static SnapshotVersion createSnapshotVersion(String classifier, String extension, String version, String updated) {
        SnapshotVersion snapshotVersion = MetadataFactory.eINSTANCE.createSnapshotVersion();
        snapshotVersion.setExtension(extension);
        snapshotVersion.setValue(version);
        snapshotVersion.setUpdated(updated);
        if (classifier != null) {
            snapshotVersion.setClassifier(classifier);
        }
        return snapshotVersion;
    }

    static class MavenMetadataHelper {
        private String groupId;
        private String artifactId;
        private List<Version> versionList;
        private Map<Version, Boolean> snapshots;
        private VersionFormat versionFormat;
        private boolean finalized;
        private boolean hasSources;

        MavenMetadataHelper(String groupId, String artifactId, VersionFormat versionFormat, boolean hasSources) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.versionList = new ArrayList<Version>();
            this.snapshots = new HashMap<Version, Boolean>();
            this.versionFormat = versionFormat;
            this.hasSources = hasSources;
        }

        public void addVersion(Version version, boolean isSnapshot) {
            if (this.finalized) {
                throw new Error("Version added after finalization");
            }
            this.versionList.add(version);
            this.snapshots.put(version, isSnapshot);
        }

        private void finalizeMetadata() {
            Collections.sort(this.versionList);
            this.finalized = true;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getRelativePath() {
            return String.valueOf(this.groupId.replace('.', '/')) + "/" + this.artifactId;
        }

        public Version getRelease() {
            this.finalizeMetadata();
            Version[] versions = this.versionList.toArray(new Version[this.versionList.size()]);
            int idx = versions.length - 1;
            while (idx >= 0) {
                String qualifier = null;
                try {
                    if (versions[idx] instanceof BasicVersion) {
                        qualifier = ((BasicVersion)versions[idx]).getQualifier();
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                if ((qualifier == null || qualifier.length() <= 0 || qualifier.charAt(0) != 'R' && qualifier.charAt(0) != 'M') && this.snapshots.get(versions[idx]) != Boolean.TRUE && !versions[idx].toString().contains("-SNAPSHOT")) {
                    return versions[idx];
                }
                --idx;
            }
            return null;
        }

        public Version getLatest() {
            Object[] sortable = this.versionList.toArray(new Version[this.versionList.size()]);
            Arrays.sort(sortable);
            return sortable[sortable.length - 1];
        }

        public VersionFormat getVersionFormat() {
            return this.versionFormat;
        }

        public List<Version> getVersions() {
            this.finalizeMetadata();
            return this.versionList;
        }

        public boolean hasSources() {
            return this.hasSources;
        }
    }
}

