/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.engine.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cbi.p2repo.aggregator.engine.internal.MultiRangeRequirement;
import org.eclipse.cbi.p2repo.util.LogUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryIO;
import org.eclipse.equinox.internal.p2.metadata.repository.io.MetadataParser;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.spi.AbstractMetadataRepository;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Deprecated
public class InternalMetadataRepositoryIO
extends MetadataRepositoryIO {
    private static final String NAMESPACE_ATTRIBUTE = "namespace";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String[] MANDATORY_REQIUREMENT_ATTRIBUTES = new String[]{"namespace", "name"};
    private static final String[] OPTIONAL_REQIUREMENT_ATTRIBUTES = new String[0];
    private static final String REQUIREMENT_VERSIONS_ELEMENT = "versions";
    private static final String REQUIREMENT_VERSION_ELEMENT = "version";
    private static final String REQUIREMENT_VERSION_RANGE_ELEMENT = "range";
    private static final String REQUIREMENT_VERSION_SERIALIZED_ATTRIBUTE = "serialized";

    public InternalMetadataRepositoryIO(IProvisioningAgent agent) {
        super(agent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMetadataRepository read(URL location, InputStream input, IProgressMonitor monitor) throws ProvisionException {
        BufferedInputStream bufferedInput = null;
        try {
            try {
                bufferedInput = new BufferedInputStream(input);
                InternalParser repositoryParser = new InternalParser(Platform.getBundle((String)"org.eclipse.equinox.p2.metadata.repository").getBundleContext(), "org.eclipse.equinox.p2.metadata.repository");
                repositoryParser.parse(input, monitor);
                IStatus result = repositoryParser.getStatus();
                switch (result.getSeverity()) {
                    case 8: {
                        throw new OperationCanceledException();
                    }
                    case 4: {
                        throw new ProvisionException(result);
                    }
                    case 1: 
                    case 2: {
                        LogHelper.log((IStatus)result);
                        break;
                    }
                }
                IMetadataRepository iMetadataRepository = repositoryParser.getRepository();
                return iMetadataRepository;
            }
            catch (OperationCanceledException operationCanceledException) {
                LogUtils.info((String)"Operation canceled.", (Object[])new Object[0]);
                return null;
            }
            finally {
                if (bufferedInput != null) {
                    bufferedInput.close();
                }
            }
        }
        catch (IOException ioe) {
            String msg = NLS.bind((String)Messages.io_failedRead, (Object)location);
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1002, msg, (Throwable)ioe));
        }
    }

    public void write(IMetadataRepository repository, OutputStream output) throws IOException {
        try (BufferedOutputStream bufferedOutput = null;){
            bufferedOutput = new BufferedOutputStream(output);
            InternalWriter repositoryWriter = new InternalWriter(bufferedOutput, repository.getClass());
            repositoryWriter.write(repository);
        }
    }

    private class InternalParser
    extends MetadataParser
    implements XMLConstants {
        private IMetadataRepository theRepository;

        public InternalParser(BundleContext context, String bundleId) {
            super(context, bundleId);
            this.theRepository = null;
        }

        protected String getErrorMessage() {
            return Messages.io_parseError;
        }

        public IMetadataRepository getRepository() {
            return this.theRepository;
        }

        protected Object getRootObject() {
            return this.theRepository;
        }

        public synchronized void parse(InputStream stream, IProgressMonitor monitor) throws IOException {
            this.status = null;
            this.setProgressMonitor(monitor);
            monitor.beginTask(Messages.repo_loading, -1);
            try {
                try {
                    this.getParser();
                    InternalRepositoryHandler repositoryHandler = new InternalRepositoryHandler();
                    this.xmlReader.setContentHandler((ContentHandler)((Object)new InternalRepositoryDocHandler("repository", repositoryHandler)));
                    this.xmlReader.parse(new InputSource(stream));
                    if (this.isValidXML()) {
                        this.theRepository = repositoryHandler.getRepository();
                    }
                }
                catch (SAXException e) {
                    if (!(e.getException() instanceof OperationCanceledException)) {
                        throw new IOException(e.getMessage());
                    }
                    monitor.done();
                    stream.close();
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e.getMessage());
                }
            }
            finally {
                monitor.done();
                stream.close();
            }
        }

        public String toString() {
            return null;
        }

        protected class InternalInstallableUnitHandler
        extends MetadataParser.InstallableUnitHandler {
            private List<MetadataFactory.InstallableUnitDescription> unitsPointer;
            private InternalRequirementsHandler requirementsHandler;

            public InternalInstallableUnitHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<MetadataFactory.InstallableUnitDescription> units) {
                super((MetadataParser)InternalParser.this, parentHandler, attributes, units);
                this.requirementsHandler = null;
                this.unitsPointer = units;
            }

            protected void finished() {
                if (InternalParser.this.isValidXML()) {
                    super.finished();
                    MetadataFactory.InstallableUnitDescription currentUnit = this.unitsPointer.get(this.unitsPointer.size() - 1);
                    IRequirement[] requiredCapabilities = this.requirementsHandler == null ? new IRequirement[]{} : this.requirementsHandler.getRequirements();
                    currentUnit.setRequiredCapabilities(requiredCapabilities);
                }
            }

            public void startElement(String name, Attributes attributes) {
                InternalParser.this.checkCancel();
                if ("requires".equals(name)) {
                    if (this.requirementsHandler == null) {
                        this.requirementsHandler = new InternalRequirementsHandler((XMLParser.AbstractHandler)this, attributes);
                    } else {
                        InternalParser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else {
                    super.startElement(name, attributes);
                }
            }
        }

        protected class InternalInstallableUnitsHandler
        extends MetadataParser.AbstractMetadataHandler {
            private ArrayList<MetadataFactory.InstallableUnitDescription> units;

            public InternalInstallableUnitsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
                super((MetadataParser)InternalParser.this, (ContentHandler)parentHandler, "units");
                this.units = new ArrayList();
            }

            public IInstallableUnit[] getUnits() {
                int size = this.units.size();
                IInstallableUnit[] result = new IInstallableUnit[size];
                int i = 0;
                for (MetadataFactory.InstallableUnitDescription desc : this.units) {
                    result[i++] = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc);
                }
                return result;
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("unit")) {
                    new InternalInstallableUnitHandler((XMLParser.AbstractHandler)this, attributes, this.units);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        private final class InternalRepositoryDocHandler
        extends XMLParser.DocHandler {
            public InternalRepositoryDocHandler(String rootName, XMLParser.RootHandler rootHandler) {
                super((XMLParser)InternalParser.this, rootName, rootHandler);
            }

            public void processingInstruction(String target, String data) throws SAXException {
                Version repositoryVersion;
                if ("metadataRepository".equals(target) && !XMLConstants.XML_TOLERANCE.isIncluded(repositoryVersion = InternalParser.this.extractPIVersion(target, data))) {
                    throw new SAXException(NLS.bind((String)Messages.io_IncompatibleVersion, (Object)repositoryVersion, (Object)XMLConstants.XML_TOLERANCE));
                }
            }
        }

        private final class InternalRepositoryHandler
        extends XMLParser.RootHandler {
            private final String[] required;
            private final String[] optional;
            private InternalInstallableUnitsHandler unitsHandler;
            private XMLParser.PropertiesHandler propertiesHandler;
            private MetadataParser.RepositoryReferencesHandler repositoryReferencesHandler;
            private AbstractMetadataRepository repository;
            private AbstractMetadataRepository.RepositoryState state;

            public InternalRepositoryHandler() {
                super((XMLParser)InternalParser.this);
                this.required = new String[]{InternalMetadataRepositoryIO.NAME_ATTRIBUTE, "type", InternalMetadataRepositoryIO.REQUIREMENT_VERSION_ELEMENT};
                this.optional = new String[]{"description", "provider"};
                this.unitsHandler = null;
                this.propertiesHandler = null;
                this.repositoryReferencesHandler = null;
                this.repository = null;
                this.state = new AbstractMetadataRepository.RepositoryState();
            }

            protected void finished() {
                if (InternalParser.this.isValidXML()) {
                    this.state.Properties = this.propertiesHandler == null ? new OrderedProperties(0) : this.propertiesHandler.getProperties();
                    this.state.Units = this.unitsHandler == null ? new IInstallableUnit[]{} : this.unitsHandler.getUnits();
                    this.state.Repositories = this.repositoryReferencesHandler == null ? new RepositoryReference[]{} : this.repositoryReferencesHandler.getReferences();
                    try {
                        if (this.state.Type == null) {
                            return;
                        }
                        Class<?> clazz = Class.forName(this.state.Type);
                        Object repositoryObject = clazz.newInstance();
                        if (repositoryObject instanceof AbstractMetadataRepository) {
                            this.repository = (AbstractMetadataRepository)repositoryObject;
                            this.repository.initialize(this.state);
                        }
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }

            public IMetadataRepository getRepository() {
                return this.repository;
            }

            protected void handleRootAttributes(Attributes attributes) {
                String[] values = this.parseAttributes(attributes, this.required, this.optional);
                Version version = InternalParser.this.checkVersion(this.elementHandled, InternalMetadataRepositoryIO.REQUIREMENT_VERSION_ELEMENT, values[2]);
                this.state.Name = values[0];
                this.state.Type = values[1];
                this.state.Version = version;
                this.state.Description = values[3];
                this.state.Provider = values[4];
                this.state.Location = null;
            }

            public void startElement(String name, Attributes attributes) {
                InternalParser.this.checkCancel();
                if ("properties".equals(name)) {
                    if (this.propertiesHandler == null) {
                        this.propertiesHandler = new XMLParser.PropertiesHandler((XMLParser)InternalParser.this, (ContentHandler)((Object)this), attributes);
                    } else {
                        InternalParser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else if ("units".equals(name)) {
                    if (this.unitsHandler == null) {
                        this.unitsHandler = new InternalInstallableUnitsHandler((XMLParser.AbstractHandler)this, attributes);
                    } else {
                        InternalParser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else if ("references".equals(name)) {
                    if (this.repositoryReferencesHandler == null) {
                        this.repositoryReferencesHandler = new MetadataParser.RepositoryReferencesHandler((MetadataParser)InternalParser.this, (XMLParser.AbstractHandler)this, attributes);
                    } else {
                        InternalParser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        protected class InternalRequirementHandler
        extends XMLParser.AbstractHandler {
            private List<IRequirement> requirements;
            private String namespace;
            private String name;
            private Set<Version> versions;
            private Set<VersionRange> versionRanges;
            private XMLParser.TextHandler filterHandler;
            private InternalRequirementVersionsHandler versionsHandler;

            public InternalRequirementHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<IRequirement> requirements) {
                super((XMLParser)InternalParser.this, (ContentHandler)parentHandler, "required");
                this.versions = null;
                this.versionRanges = null;
                this.filterHandler = null;
                this.versionsHandler = null;
                this.requirements = requirements;
                String[] values = this.parseAttributes(attributes, MANDATORY_REQIUREMENT_ATTRIBUTES, OPTIONAL_REQIUREMENT_ATTRIBUTES);
                this.namespace = values[0];
                this.name = values[1];
            }

            protected void finished() {
                if (InternalParser.this.isValidXML()) {
                    IMatchExpression filter = null;
                    if (this.filterHandler != null) {
                        filter = ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)this.filterHandler.getText()), new Object[0]);
                    }
                    if (this.versionsHandler != null) {
                        this.versions = this.versionsHandler.getVersions();
                        this.versionRanges = this.versionsHandler.getVersionRanges();
                    }
                    this.requirements.add(new MultiRangeRequirement(this.name, this.namespace, this.versions, this.versionRanges, (IMatchExpression<IInstallableUnit>)filter));
                }
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("filter")) {
                    this.filterHandler = new XMLParser.TextHandler((XMLParser)InternalParser.this, (XMLParser.AbstractHandler)this, "filter", attributes);
                } else if (name.equals(InternalMetadataRepositoryIO.REQUIREMENT_VERSIONS_ELEMENT)) {
                    this.versionsHandler = new InternalRequirementVersionsHandler(this);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        protected class InternalRequirementVersionHandler
        extends XMLParser.AbstractHandler {
            private Version version;
            private Set<Version> versions;

            public InternalRequirementVersionHandler(InternalRequirementVersionsHandler parentHandler, Attributes attributes, Set<Version> versions) {
                super((XMLParser)InternalParser.this, (ContentHandler)((Object)parentHandler), InternalMetadataRepositoryIO.REQUIREMENT_VERSION_ELEMENT);
                this.versions = versions;
                String[] versionString = this.parseAttributes(attributes, new String[]{InternalMetadataRepositoryIO.REQUIREMENT_VERSION_SERIALIZED_ATTRIBUTE}, new String[0]);
                this.version = Version.create((String)versionString[0]);
            }

            protected void finished() {
                if (InternalParser.this.isValidXML()) {
                    this.versions.add(this.version);
                }
            }

            public void startElement(String name, Attributes attributes) throws SAXException {
                this.invalidElement(name, attributes);
            }
        }

        protected class InternalRequirementVersionRangeHandler
        extends XMLParser.AbstractHandler {
            private VersionRange versionRange;
            private Set<VersionRange> versionRanges;

            public InternalRequirementVersionRangeHandler(InternalRequirementVersionsHandler parentHandler, Attributes attributes, Set<VersionRange> versionRanges) {
                super((XMLParser)InternalParser.this, (ContentHandler)((Object)parentHandler), InternalMetadataRepositoryIO.REQUIREMENT_VERSION_RANGE_ELEMENT);
                this.versionRanges = versionRanges;
                String[] versionRangeString = this.parseAttributes(attributes, new String[]{InternalMetadataRepositoryIO.REQUIREMENT_VERSION_SERIALIZED_ATTRIBUTE}, new String[0]);
                this.versionRange = new VersionRange(versionRangeString[0]);
            }

            protected void finished() {
                if (InternalParser.this.isValidXML()) {
                    this.versionRanges.add(this.versionRange);
                }
            }

            public void startElement(String name, Attributes attributes) throws SAXException {
                this.invalidElement(name, attributes);
            }
        }

        protected class InternalRequirementVersionsHandler
        extends XMLParser.AbstractHandler {
            private Set<Version> versions;
            private Set<VersionRange> versionRanges;

            public InternalRequirementVersionsHandler(InternalRequirementHandler parentHandler) {
                super((XMLParser)InternalParser.this, (ContentHandler)((Object)parentHandler), InternalMetadataRepositoryIO.REQUIREMENT_VERSIONS_ELEMENT);
                this.versions = new LinkedHashSet<Version>();
                this.versionRanges = new LinkedHashSet<VersionRange>();
            }

            public Set<VersionRange> getVersionRanges() {
                return this.versionRanges;
            }

            public Set<Version> getVersions() {
                return this.versions;
            }

            public void startElement(String name, Attributes attributes) throws SAXException {
                if (name.equals(InternalMetadataRepositoryIO.REQUIREMENT_VERSION_ELEMENT)) {
                    new InternalRequirementVersionHandler(this, attributes, this.versions);
                } else if (name.equals(InternalMetadataRepositoryIO.REQUIREMENT_VERSION_RANGE_ELEMENT)) {
                    new InternalRequirementVersionRangeHandler(this, attributes, this.versionRanges);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        protected class InternalRequirementsHandler
        extends MetadataParser.AbstractMetadataHandler {
            private List<IRequirement> requirements;

            public InternalRequirementsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
                super((MetadataParser)InternalParser.this, (ContentHandler)parentHandler, "requires");
                this.requirements = new ArrayList<IRequirement>();
            }

            public IRequirement[] getRequirements() {
                return this.requirements.toArray(new IRequirement[this.requirements.size()]);
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("required")) {
                    if (attributes.getIndex(InternalMetadataRepositoryIO.REQUIREMENT_VERSION_RANGE_ELEMENT) != -1) {
                        new MetadataParser.RequirementHandler((MetadataParser)InternalParser.this, (XMLParser.AbstractHandler)this, attributes, this.requirements);
                    } else {
                        new InternalRequirementHandler((XMLParser.AbstractHandler)this, attributes, this.requirements);
                    }
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }
    }

    protected class InternalWriter
    extends MetadataRepositoryIO.Writer {
        public InternalWriter(OutputStream output, Class<? extends IMetadataRepository> repositoryClass) throws IOException {
            super((MetadataRepositoryIO)InternalMetadataRepositoryIO.this, output, repositoryClass);
        }

        protected void writeRequiredCapability(IRequirement requirement) {
            if (requirement instanceof MultiRangeRequirement) {
                MultiRangeRequirement req = (MultiRangeRequirement)requirement;
                this.start("required");
                this.attribute(InternalMetadataRepositoryIO.NAMESPACE_ATTRIBUTE, req.getNamespace());
                this.attribute(InternalMetadataRepositoryIO.NAME_ATTRIBUTE, req.getName());
                this.start(InternalMetadataRepositoryIO.REQUIREMENT_VERSIONS_ELEMENT);
                for (Version version : req.getVersions()) {
                    this.start(InternalMetadataRepositoryIO.REQUIREMENT_VERSION_ELEMENT);
                    this.attribute(InternalMetadataRepositoryIO.REQUIREMENT_VERSION_SERIALIZED_ATTRIBUTE, version);
                    this.end(InternalMetadataRepositoryIO.REQUIREMENT_VERSION_ELEMENT);
                }
                this.end(InternalMetadataRepositoryIO.REQUIREMENT_VERSIONS_ELEMENT);
                if (requirement.getFilter() != null) {
                    this.writeTrimmedCdata("filter", requirement.getFilter().toString());
                }
                this.end("required");
            } else {
                super.writeRequirement(requirement);
            }
        }

        private void writeTrimmedCdata(String element, String filter) {
            String trimmed;
            if (filter != null && (trimmed = filter.trim()).length() > 0) {
                this.start(element);
                this.cdata(trimmed);
                this.end(element);
            }
        }
    }

    private static interface XMLConstants
    extends org.eclipse.equinox.internal.p2.metadata.repository.io.XMLConstants {
        public static final Version COMPATIBLE_VERSION = Version.createOSGi((int)1, (int)0, (int)0);
        public static final VersionRange XML_TOLERANCE = new VersionRange(COMPATIBLE_VERSION, true, Version.createOSGi((int)2, (int)0, (int)0), false);
        public static final String PI_REPOSITORY_TARGET = "metadataRepository";
        public static final String REPOSITORY_ELEMENT = "repository";
    }
}

