/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.osgi.filter.impl;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cbi.p2repo.osgi.filter.Filter;
import org.eclipse.cbi.p2repo.osgi.filter.impl.FilterImpl;
import org.eclipse.cbi.p2repo.osgi.filter.impl.Parser;

class AndOrFilterImpl
extends FilterImpl {
    private final FilterImpl[] filters;

    AndOrFilterImpl(int operation, FilterImpl[] filters) {
        super(operation, null);
        this.filters = filters;
    }

    @Override
    public void addConsultedAttributes(Map<String, String[]> propertyChoices) {
        int i = 0;
        while (i < this.filters.length) {
            this.filters[i].addConsultedAttributes(propertyChoices);
            ++i;
        }
    }

    @Override
    public int compareTo(FilterImpl o) {
        int cmp = this.internalCompareTo(o);
        if (cmp != 0) {
            return cmp;
        }
        int top = this.filters.length;
        FilterImpl[] o_filters = ((AndOrFilterImpl)o).filters;
        if (top > o_filters.length) {
            return 1;
        }
        if (top < o_filters.length) {
            return -1;
        }
        int idx = 0;
        while (idx < top) {
            cmp = this.filters[idx].compareTo(o_filters[idx]);
            if (cmp != 0) {
                return cmp;
            }
            ++idx;
        }
        return 0;
    }

    @Override
    public FilterImpl stripFilter(Filter subFilter) {
        ArrayList<FilterImpl> newList = new ArrayList<FilterImpl>(this.filters.length);
        boolean change = false;
        int idx = 0;
        while (idx < this.filters.length) {
            FilterImpl child = this.filters[idx];
            if (child.equals(subFilter)) {
                change = true;
            } else if (child instanceof AndOrFilterImpl) {
                FilterImpl newChild = ((AndOrFilterImpl)child).stripFilter(subFilter);
                if (child != newChild) {
                    change = true;
                }
                if (newChild != null) {
                    newList.add(newChild);
                }
            } else {
                newList.add(child);
            }
            ++idx;
        }
        return change ? Parser.normalize(newList, this.getOp()) : this;
    }

    @Override
    FilterImpl addFilter(FilterImpl subFilter, int op) {
        FilterImpl result;
        if (this.getOp() == op) {
            int top = this.filters.length;
            int idx = 0;
            while (idx < top) {
                if (this.filters[idx].equals(subFilter)) {
                    return this;
                }
                ++idx;
            }
            ArrayList<FilterImpl> filterList = new ArrayList<FilterImpl>(top + 1);
            int idx2 = 0;
            while (idx2 < top) {
                filterList.add(this.filters[idx2]);
                ++idx2;
            }
            filterList.add(subFilter);
            result = Parser.normalize(filterList, this.getOp());
        } else {
            result = super.addFilter(subFilter, op);
        }
        return result;
    }

    @Override
    FilterImpl[] getFilterImpls() {
        return this.filters;
    }

    @Override
    boolean match0(Map<String, ? extends Object> properties) {
        switch (this.getOp()) {
            case 7: {
                int i = 0;
                int size = this.filters.length;
                while (i < size) {
                    if (!this.filters[i].match0(properties)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 8: {
                int i = 0;
                int size = this.filters.length;
                while (i < size) {
                    if (this.filters[i].match0(properties)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    void toString(StringBuilder sb) {
        sb.append('(');
        if (this.getOp() == 7) {
            sb.append('&');
        } else {
            sb.append('|');
        }
        int i = 0;
        int size = this.filters.length;
        while (i < size) {
            sb.append(this.filters[i].toString());
            ++i;
        }
        sb.append(')');
    }
}

