/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.maven.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cbi.p2repo.aggregator.VersionFormat;
import org.eclipse.cbi.p2repo.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class VersionUtil {
    public static final String DASH_SNAPSHOT = "-SNAPSHOT";
    private static Pattern versionRangePattern = Pattern.compile("^(\\([)([^,]+),([^,]+)(\\)])$");
    private static final Pattern timestampPattern = Pattern.compile("^((?:19|20)\\d{2}(?:0[1-9]|1[012])(?:0[1-9]|[12][0-9]|3[01]))(?:\\.((?:[01][0-9]|2[0-3])[0-5][0-9][0-5][0-9]))?$");
    private static final Pattern mavenTrickPattern = Pattern.compile("^\\d+\\.\\d+\\.\\d+(?:\\.\\d+-[a-zA-Z][a-zA-Z0-9_]*)?$");
    private static final Pattern osgiPattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+)\\.([a-zA-Z0-9_-]+)$");
    private static final Pattern extractSnapshotQualifierPattern = Pattern.compile("(.*[^0-9])?(\\d\\d\\d\\d\\d\\d\\d\\d)-?(\\d\\d\\d\\d(\\d\\d)?).*");

    public static Version createVersion(String versionStr) throws CoreException {
        if ((versionStr = StringUtils.trimmedOrNull((String)versionStr)) == null) {
            return null;
        }
        Matcher m = timestampPattern.matcher(versionStr);
        if (m.matches()) {
            return VersionUtil.createVersionFromFormatAndOriginal("S=[0-9];={8};[.S=[0-9];={6};='000000';]", versionStr);
        }
        try {
            return VersionUtil.createVersionFromFormatAndOriginal("n[.n=0;[.n=0;]][d?S=M;]", versionStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return VersionUtil.createVersionFromFormatAndOriginal("S", versionStr);
        }
    }

    public static Version createVersionFromFormatAndOriginal(String format, String versionStr) {
        return Version.parseVersion((String)("format(" + format + "):" + versionStr));
    }

    public static VersionRange createVersionRange(String versionRangeString) throws CoreException {
        String vr = StringUtils.trimmedOrNull((String)versionRangeString);
        if (vr == null) {
            return VersionRange.emptyRange;
        }
        Matcher m = versionRangePattern.matcher(vr);
        if (m.matches()) {
            return new VersionRange(VersionUtil.createVersion(m.group(2)), "[".equals(m.group(1)), VersionUtil.createVersion(m.group(3)), "[".equals(m.group(4)));
        }
        Version v = VersionUtil.createVersion(vr);
        return new VersionRange(v, true, Version.MAX_VERSION, true);
    }

    public static String getVersionString(Version version) {
        String versionString = version.getOriginal();
        if (versionString == null) {
            versionString = version.toString();
        }
        return versionString;
    }

    public static String getVersionString(Version version, VersionFormat versionFormat, boolean fineGrained, int mavenBuildNumber) {
        Matcher matcher;
        if (version instanceof MappedVersion) {
            return version.getOriginal();
        }
        String versionString = VersionUtil.getVersionString(version);
        if (versionFormat == VersionFormat.NORMAL) {
            return versionString;
        }
        Matcher m = mavenTrickPattern.matcher(versionString);
        if (m.matches()) {
            return versionString;
        }
        m = osgiPattern.matcher(versionString);
        if (!m.matches()) {
            return versionString;
        }
        if (versionFormat == VersionFormat.MAVEN_RELEASE) {
            return m.group(1);
        }
        if (versionFormat == VersionFormat.MAVEN_SNAPSHOT && !fineGrained) {
            return String.valueOf(m.group(1)) + DASH_SNAPSHOT;
        }
        StringBuilder bld = new StringBuilder();
        bld.append(m.group(1));
        bld.append('-');
        String qualifier = m.group(2);
        if (versionFormat == VersionFormat.MAVEN_SNAPSHOT && (matcher = extractSnapshotQualifierPattern.matcher(qualifier)).matches()) {
            qualifier = String.valueOf(matcher.group(2)) + '.' + matcher.group(3);
            if (qualifier.length() == 13) {
                qualifier = String.valueOf(qualifier) + "00";
            }
            qualifier = String.valueOf(qualifier) + "-" + mavenBuildNumber;
        }
        bld.append(qualifier);
        return bld.toString();
    }

    public static Version mappedVersion(String original, VersionFormat versionFormat) {
        int idx = original.indexOf(DASH_SNAPSHOT);
        String version = idx > -1 ? original.substring(0, idx) : original;
        return new MappedVersion(Version.create((String)version), original, versionFormat);
    }

    public static String versionAsSnapshot(String version) {
        int dash = version.indexOf(45);
        if (dash != -1) {
            version = String.valueOf(version.substring(0, dash)) + DASH_SNAPSHOT;
        }
        return version;
    }

    private static class MappedVersion
    extends Version {
        private static final long serialVersionUID = 1L;
        private final String mappedVersion;
        private final Version version;
        private final VersionFormat versionFormat;

        public MappedVersion(Version version, String mappedVersion, VersionFormat versionFormat) {
            this.mappedVersion = mappedVersion;
            this.version = version;
            this.versionFormat = versionFormat;
        }

        public int compareTo(Version o) {
            int vComp;
            VersionFormat oFormat = VersionFormat.NORMAL;
            String oMapped = null;
            if (o instanceof MappedVersion) {
                MappedVersion mv = (MappedVersion)o;
                o = mv.version;
                oFormat = mv.versionFormat;
                oMapped = mv.mappedVersion;
            }
            if ((vComp = this.version.compareTo((Object)o)) != 0) {
                return vComp;
            }
            if (this.versionFormat == oFormat) {
                return oMapped != null ? this.mappedVersion.compareTo(oMapped) : 0;
            }
            return this.versionFormat.compareTo((Enum)oFormat);
        }

        public IVersionFormat getFormat() {
            return this.version.getFormat();
        }

        public String getOriginal() {
            return this.mappedVersion;
        }

        public Comparable<?> getPad() {
            return this.version.getPad();
        }

        public Comparable<?> getSegment(int index) {
            return this.version.getSegment(index);
        }

        public int getSegmentCount() {
            return this.version.getSegmentCount();
        }

        public boolean isOSGiCompatible() {
            return this.versionFormat != VersionFormat.MAVEN_SNAPSHOT && this.version.isOSGiCompatible();
        }

        public void toString(StringBuffer sb) {
            sb.append(this.mappedVersion);
        }
    }
}

