/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Predicate;

class ComputeProjectOrder {
    private ComputeProjectOrder() {
    }

    static <T> VertexOrder<T> computeVertexOrder(SortedSet<? extends T> vertexes, List<? extends T[]> references, Class<T> clazz) {
        Object[][] knots;
        Digraph<Object> g1 = new Digraph<Object>(clazz);
        for (Object e : vertexes) {
            g1.addVertex(e);
        }
        for (Object[] objectArray : references) {
            Object object = objectArray[0];
            Iterator<Object> q = objectArray[1];
            g1.addEdge(q, object);
        }
        g1.freeze();
        Digraph<Object> digraph = new Digraph<Object>(clazz);
        List<T> resortedVertexes = g1.idsByDFSFinishTime(false);
        for (T t : resortedVertexes) {
            digraph.addVertex(t);
        }
        for (Object[] objectArray : references) {
            Object p = objectArray[0];
            Object q = objectArray[1];
            digraph.addEdge(p, q);
        }
        digraph.freeze();
        List<Object> list = digraph.idsByDFSFinishTime(true);
        Object[] orderedVertexes = (Object[])Array.newInstance(clazz, list.size());
        list.toArray(orderedVertexes);
        boolean hasCycles = digraph.containsCycles();
        if (hasCycles) {
            List<T[]> knotList = digraph.nonTrivialComponents();
            Class<?> arrayClass = Array.newInstance(clazz, 0).getClass();
            knots = (Object[][])Array.newInstance(arrayClass, knotList.size());
            knotList.toArray((T[])knots);
        } else {
            knots = (Object[][])Array.newInstance(clazz, 0, 0);
        }
        return new VertexOrder<Object>(orderedVertexes, hasCycles, knots);
    }

    static <T> VertexOrder<T> filterVertexOrder(VertexOrder<T> order, Predicate<T> filter, Class<T> clazz) {
        int filteredCount = 0;
        boolean[] filterMatches = new boolean[order.vertexes.length];
        int i = 0;
        while (i < order.vertexes.length) {
            filterMatches[i] = filter.test(order.vertexes[i]);
            if (filterMatches[i]) {
                ++filteredCount;
            }
            ++i;
        }
        if (filteredCount == 0) {
            return order;
        }
        Object[] reducedVertexes = (Object[])Array.newInstance(clazz, order.vertexes.length - filteredCount);
        int i2 = 0;
        int j = 0;
        while (i2 < order.vertexes.length) {
            if (!filterMatches[i2]) {
                reducedVertexes[j] = order.vertexes[i2];
                ++j;
            }
            ++i2;
        }
        ArrayList<Object[]> reducedKnots = new ArrayList<Object[]>(order.knots.length);
        T[][] TArray = order.knots;
        int n = order.knots.length;
        int n2 = 0;
        while (n2 < n) {
            T[] knot = TArray[n2];
            ArrayList knotList = new ArrayList(knot.length);
            T[] TArray2 = knot;
            int n3 = knot.length;
            int n4 = 0;
            while (n4 < n3) {
                Object vertex = TArray2[n4];
                if (!filter.test(vertex)) {
                    knotList.add(vertex);
                }
                ++n4;
            }
            if (knotList.size() > 1) {
                reducedKnots.add(knotList.toArray((Object[])Array.newInstance(clazz, knotList.size())));
            }
            ++n2;
        }
        Class<?> arrayClass = Array.newInstance(clazz, 0).getClass();
        return new VertexOrder<Object>(reducedVertexes, reducedKnots.size() > 0, (Object[][])reducedKnots.toArray((T[])((Object[][])Array.newInstance(arrayClass, reducedKnots.size()))));
    }

    private static class Digraph<T> {
        private List<Vertex<T>> vertexList = new ArrayList<Vertex<T>>(100);
        private Map<T, Vertex<T>> vertexMap = new HashMap<T, Vertex<T>>(100);
        private int time;
        private boolean initialized = false;
        private boolean cycles = false;
        private Class<T> clazz;

        public Digraph(Class<T> clazz) {
            this.clazz = clazz;
        }

        public void freeze() {
            if (!this.initialized) {
                this.initialized = true;
                this.DFS();
            }
        }

        public void addVertex(T id) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex<T> vertex = new Vertex<T>(id);
            Vertex<T> existing = this.vertexMap.put(id, vertex);
            if (existing != null) {
                throw new IllegalArgumentException();
            }
            this.vertexList.add(vertex);
        }

        public void addEdge(T fromId, T toId) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex<T> fromVertex = this.vertexMap.get(fromId);
            Vertex<T> toVertex = this.vertexMap.get(toId);
            if (fromVertex == null) {
                throw new IllegalArgumentException();
            }
            if (toVertex == null) {
                throw new IllegalArgumentException();
            }
            fromVertex.adjacent.add(toVertex);
        }

        public List<T> idsByDFSFinishTime(boolean increasing) {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            int len = this.vertexList.size();
            Object[] r = (Object[])Array.newInstance(this.clazz, len);
            for (Vertex<T> vertex : this.vertexList) {
                int f = vertex.finishTime;
                if (increasing) {
                    r[f - 1] = vertex.id;
                    continue;
                }
                r[len - f] = vertex.id;
            }
            return Arrays.asList(r);
        }

        public boolean containsCycles() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            return this.cycles;
        }

        public List<T[]> nonTrivialComponents() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            HashMap components = new HashMap();
            for (Vertex<T> vertex : this.vertexList) {
                if (vertex.predecessor == null) continue;
                Vertex<T> root = vertex;
                while (root.predecessor != null) {
                    root = root.predecessor;
                }
                ArrayList component = (ArrayList)components.get(root);
                if (component == null) {
                    component = new ArrayList(2);
                    component.add(root.id);
                    components.put(root, component);
                }
                component.add(vertex.id);
            }
            ArrayList<T[]> result = new ArrayList<T[]>(components.size());
            for (List component : components.values()) {
                if (component.size() <= 1) continue;
                result.add(component.toArray((Object[])Array.newInstance(this.clazz, component.size())));
            }
            return result;
        }

        private void DFS() {
            Integer NEXT_VERTEX_OBJECT = 1;
            Integer AFTER_NEXTED_DFS_VISIT_OBJECT = 4;
            this.time = 0;
            ArrayList<Object> stack = new ArrayList<Object>(Math.max(1, this.vertexList.size()));
            Iterator allAdjacent = null;
            Vertex vertex = null;
            Iterator<Vertex<T>> allV = this.vertexList.iterator();
            int state = 1;
            block6: while (true) {
                switch (state) {
                    case 1: {
                        if (!allV.hasNext()) break block6;
                        Vertex nextVertex = allV.next();
                        if (nextVertex.color == "white") {
                            stack.add(NEXT_VERTEX_OBJECT);
                            vertex = nextVertex;
                            state = 2;
                            continue block6;
                        }
                        state = 1;
                        continue block6;
                    }
                    case 2: {
                        vertex.color = "grey";
                        allAdjacent = vertex.adjacent.iterator();
                        state = 3;
                        continue block6;
                    }
                    case 3: {
                        if (allAdjacent.hasNext()) {
                            Vertex adjVertex = (Vertex)allAdjacent.next();
                            if (adjVertex.color == "white") {
                                adjVertex.predecessor = vertex;
                                stack.add(allAdjacent);
                                stack.add(vertex);
                                stack.add(AFTER_NEXTED_DFS_VISIT_OBJECT);
                                vertex = adjVertex;
                                state = 2;
                                continue block6;
                            }
                            if (adjVertex.color == "grey") {
                                this.cycles = true;
                            }
                            state = 3;
                            continue block6;
                        }
                        vertex.color = "black";
                        vertex.finishTime = ++this.time;
                        state = (Integer)stack.remove(stack.size() - 1);
                        continue block6;
                    }
                    case 4: {
                        vertex = (Vertex)stack.remove(stack.size() - 1);
                        allAdjacent = (Iterator)stack.remove(stack.size() - 1);
                        state = 3;
                    }
                    default: {
                        continue block6;
                    }
                }
                break;
            }
        }

        public static class Vertex<T> {
            public static final String WHITE = "white";
            public static final String GREY = "grey";
            public static final String BLACK = "black";
            public String color = "white";
            public Vertex<T> predecessor = null;
            public int finishTime;
            public T id;
            public List<Vertex<T>> adjacent = new ArrayList<Vertex<T>>(3);

            public Vertex(T id) {
                this.id = id;
            }
        }
    }

    static final class VertexOrder<T> {
        public T[] vertexes;
        public boolean hasCycles;
        public T[][] knots;

        public VertexOrder(T[] vertexes, boolean hasCycles, T[][] knots) {
            this.vertexes = vertexes;
            this.hasCycles = hasCycles;
            this.knots = knots;
        }
    }
}

