/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.processors.checksum;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.Messages;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.osgi.util.NLS;

public final class ChecksumVerifier
extends ProcessingStep {
    private String expectedChecksum;
    private MessageDigest messageDigest;
    private String algorithmName;
    private String algorithmId;

    public ChecksumVerifier(String digestAlgorithm, String algorithmId, String expectedChecksum) {
        this.algorithmName = digestAlgorithm;
        this.algorithmId = algorithmId;
        this.expectedChecksum = expectedChecksum;
        this.basicInitialize(null);
    }

    @Override
    public final void initialize(IProvisioningAgent agent, IProcessingStepDescriptor descriptor, IArtifactDescriptor context) {
        super.initialize(agent, descriptor, context);
        String data = descriptor.getData();
        this.expectedChecksum = "download.checksum".concat(".").concat(this.algorithmId).equals(data) ? (String)ChecksumHelper.getChecksums((IArtifactDescriptor)context, (String)"download.checksum").get(this.algorithmId) : ("artifact.checksum".concat(".").concat(this.algorithmId).equals(data) ? (String)ChecksumHelper.getChecksums((IArtifactDescriptor)context, (String)"artifact.checksum").get(this.algorithmId) : data);
        this.basicInitialize(descriptor);
    }

    private void basicInitialize(IProcessingStepDescriptor descriptor) {
        int code;
        int n = descriptor == null ? 4 : (code = descriptor.isRequired() ? 4 : 1);
        if (Optional.ofNullable(this.expectedChecksum).orElse("").isEmpty()) {
            this.setStatus((IStatus)new Status(code, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Error_invalid_checksum, (Object)this.algorithmName, (Object)this.expectedChecksum)));
        }
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            this.setStatus((IStatus)new Status(code, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Error_checksum_unavailable, (Object)this.algorithmName), (Throwable)e));
        }
    }

    @Override
    public final void write(int b) throws IOException {
        this.messageDigest.update((byte)b);
        this.getDestination().write(b);
    }

    @Override
    public final void close() throws IOException {
        byte[] hashBytes = this.messageDigest.digest();
        String hash = ChecksumHelper.toHexString((byte[])hashBytes);
        if (!hash.equals(this.expectedChecksum)) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1203, NLS.bind((String)Messages.Error_unexpected_checksum, (Object[])new Object[]{this.algorithmName, this.expectedChecksum, hash}), null));
        }
        super.close();
    }
}

