/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.datastream.filter;

import java.util.Iterator;
import org.palladiosimulator.edp2.datastream.AbstractDataSource;
import org.palladiosimulator.edp2.datastream.IDataSink;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataSourceListener;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.configurable.EmptyConfiguration;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.MetricDescription;

public abstract class AbstractAdapter
extends AbstractDataSource
implements IDataSink,
IDataSource {
    private IDataSource datasource;

    public AbstractAdapter(IDataSource datasource, MetricDescription metricDescription) {
        super(metricDescription);
        this.datasource = datasource;
    }

    public AbstractAdapter(MetricDescription metricDescription) {
        super(metricDescription);
    }

    @Override
    public IDataSource getDataSource() {
        return this.datasource;
    }

    public IDataStream<MeasuringValue> getDataStream() {
        IDataStream<MeasuringValue> inputDataStream = this.datasource.getDataStream();
        return new AdapterDataStream(inputDataStream);
    }

    protected boolean shouldSkip(MeasuringValue next) {
        return false;
    }

    protected MeasuringValue computeOutputFromInput(MeasuringValue next) {
        return next;
    }

    @Override
    protected PropertyConfigurable createProperties() {
        return new EmptyConfiguration();
    }

    @Override
    public MeasuringPoint getMeasuringPoint() {
        return this.datasource.getMeasuringPoint();
    }

    @Override
    public void setDataSource(IDataSource newDataSource) {
        this.datasource = newDataSource;
        ((IDataSourceListener)this.datasourceChangedListener.getEventDispatcher()).datasourceUpdated();
    }

    private final class AdapterDataStream
    implements IDataStream<MeasuringValue> {
        private int cachedSize = -1;
        private final IDataStream<MeasuringValue> inputDataStream;

        private AdapterDataStream(IDataStream<MeasuringValue> inputDataStream) {
            this.inputDataStream = inputDataStream;
        }

        @Override
        public Iterator<MeasuringValue> iterator() {
            return new AdapterIterator(this.inputDataStream.iterator());
        }

        public MetricDescription getMetricDesciption() {
            return AbstractAdapter.this.getMetricDesciption();
        }

        public boolean isCompatibleWith(MetricDescription other) {
            return AbstractAdapter.this.isCompatibleWith(other);
        }

        @Override
        public void close() {
            this.inputDataStream.close();
        }

        @Override
        public int size() {
            if (this.cachedSize < 0) {
                this.cachedSize = 0;
                if (this.inputDataStream.size() != 0) {
                    for (MeasuringValue measurement : this) {
                        ++this.cachedSize;
                    }
                }
            }
            return this.cachedSize;
        }

        private final class AdapterIterator
        implements Iterator<MeasuringValue> {
            private MeasuringValue next;
            private MeasuringValue nextNext;
            private int count = 0;
            private final Iterator<MeasuringValue> inputIterator;

            private AdapterIterator(Iterator<MeasuringValue> inputIterator) {
                this.inputIterator = inputIterator;
                this.next = this.findNext();
                this.nextNext = this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public MeasuringValue next() {
                MeasuringValue measurement = AbstractAdapter.this.computeOutputFromInput(this.next);
                if (!AdapterDataStream.this.isCompatibleWith(measurement.getMetricDesciption())) {
                    throw new RuntimeException("Metric \"" + measurement.getMetricDesciption().getName() + "\" is incompatible with expected output metric \"" + AbstractAdapter.this.getMetricDesciption().getName() + "\"");
                }
                this.next = this.nextNext;
                this.nextNext = this.findNext();
                ++this.count;
                if (!this.hasNext()) {
                    AdapterDataStream.this.cachedSize = this.count;
                }
                return measurement;
            }

            @Override
            public void remove() {
            }

            private MeasuringValue findNext() {
                MeasuringValue result = null;
                while (this.inputIterator.hasNext()) {
                    result = this.inputIterator.next();
                    if (AbstractAdapter.this.shouldSkip(result)) continue;
                }
                return this.inputIterator.hasNext() ? result : null;
            }
        }
    }
}

