/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.datastream;

import java.util.Map;
import java.util.Set;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataSourceListener;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyListener;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.metricentity.MetricEntity;

public abstract class AbstractDataSource
extends MetricEntity
implements IDataSource,
IPropertyConfigurable {
    private final PropertyConfigurable myProperties;
    protected final AbstractObservable<IDataSourceListener> datasourceChangedListener = new AbstractObservable<IDataSourceListener>(){};

    public AbstractDataSource() {
        this.myProperties = this.setupProperties();
    }

    public AbstractDataSource(MetricDescription metricDescription) {
        super(metricDescription);
        this.myProperties = this.setupProperties();
    }

    protected abstract PropertyConfigurable createProperties();

    private PropertyConfigurable setupProperties() {
        PropertyConfigurable myProperties = this.createProperties();
        myProperties.addObserver(new IPropertyListener(){

            @Override
            public void propertyChanged(String key, Object oldValue, Object newValue) {
            }

            @Override
            public void propertyChangeCompleted() {
                ((IDataSourceListener)AbstractDataSource.this.datasourceChangedListener.getEventDispatcher()).datasourceUpdated();
            }
        });
        return myProperties;
    }

    @Override
    public <G extends IPropertyConfigurable> G getConfiguration() {
        return (G)this.myProperties;
    }

    @Override
    public Map<? extends String, ? extends Object> getDefaultConfiguration() {
        return this.myProperties.getDefaultConfiguration();
    }

    @Override
    public Set<String> getKeys() {
        return this.myProperties.getKeys();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.myProperties.getProperties();
    }

    @Override
    public void setProperties(Map<String, Object> newProperties) {
        this.myProperties.setProperties(newProperties);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return this.myProperties.getAdapter(adapter);
    }

    public void addObserver(IDataSourceListener observer) {
        this.datasourceChangedListener.addObserver((Object)observer);
    }

    public void removeObserver(IDataSourceListener observer) {
        this.datasourceChangedListener.removeObserver((Object)observer);
    }

    @Override
    public Class<?> getPropertyType(String key) {
        return this.myProperties.getPropertyType(key);
    }

    @Override
    public boolean isPropertyNotSet(String key) {
        return this.myProperties.isPropertyNotSet(key);
    }

    @Override
    public void unsetProperty(String key) {
        this.myProperties.unsetProperty(key);
    }
}

