/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.datastream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.palladiosimulator.edp2.datastream.BasicDataStream;
import org.palladiosimulator.edp2.datastream.DataStream;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;

public class DataTupleStream
extends DataStream<TupleMeasurement> {
    private final List<BasicDataStream<?, ?>> childStreams;

    public DataTupleStream(List<BasicDataStream<?, ?>> childLists, MetricSetDescription metricSetDescription) {
        super((MetricDescription)metricSetDescription);
        this.childStreams = Collections.unmodifiableList(childLists);
    }

    @Override
    public Iterator<TupleMeasurement> iterator() {
        final ArrayList subIterators = new ArrayList(this.childStreams.size());
        for (BasicDataStream<?, ?> childList : this.childStreams) {
            subIterators.add(childList.iterator());
        }
        return new Iterator<TupleMeasurement>(){

            @Override
            public boolean hasNext() {
                for (Iterator subIterator : subIterators) {
                    if (subIterator.hasNext()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public TupleMeasurement next() {
                ArrayList<MeasuringValue> result = new ArrayList<MeasuringValue>(subIterators.size());
                for (Iterator subIterator : subIterators) {
                    result.add((MeasuringValue)subIterator.next());
                }
                return new TupleMeasurement(result, (MetricSetDescription)DataTupleStream.this.getMetricDesciption());
            }

            @Override
            public void remove() {
                for (Iterator subIterator : subIterators) {
                    subIterator.remove();
                }
            }
        };
    }

    @Override
    public void close() {
        for (BasicDataStream<?, ?> childStream : this.childStreams) {
            childStream.close();
        }
    }

    @Override
    public int size() {
        return this.childStreams.get(0).size();
    }
}

