/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.datastream.configurable.reflective;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyListener;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.datastream.configurable.reflective.ConfigurationProperty;

public class ReflectivePropertyConfigurable
extends PropertyConfigurable
implements IPropertyListener {
    private Map<String, Field> keyFieldMap;

    public ReflectivePropertyConfigurable() {
        this.addObserver(this);
        this.setProperties(this.getDefaultConfiguration());
    }

    @Override
    public Map<String, Object> getDefaultConfiguration() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            for (Field f : this.keyFieldMap.values()) {
                f.setAccessible(true);
                result.put(this.getKeynameForField(f), f.get(this));
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Override
    public Set<String> getKeys() {
        this.initKeyFieldMap();
        return new HashSet<String>(this.keyFieldMap.keySet());
    }

    @Override
    public void propertyChanged(String key, Object oldValue, Object newValue) {
        if (newValue != this.getNotSetConstant() && this.keyFieldMap.containsKey(key)) {
            Field f = this.keyFieldMap.get(key);
            try {
                f.setAccessible(true);
                f.set(this, newValue);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void propertyChangeCompleted() {
    }

    private void initKeyFieldMap() {
        if (this.keyFieldMap == null) {
            HashMap<String, Field> keys = new HashMap<String, Field>();
            Class<?> currentClass = this.getClass();
            while (currentClass != null) {
                Field[] fieldArray = currentClass.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    ConfigurationProperty configField = f.getAnnotation(ConfigurationProperty.class);
                    if (configField != null) {
                        keys.put(this.getKeynameForField(f), f);
                    }
                    ++n2;
                }
                currentClass = currentClass.getSuperclass();
            }
            this.keyFieldMap = Collections.unmodifiableMap(keys);
        }
    }

    private String getKeynameForField(Field f) {
        return f.getName();
    }

    @Override
    public Class<?> getPropertyType(String key) {
        return this.keyFieldMap.get(key).getType();
    }

    @Override
    public void setProperties(Map<String, Object> newProperties) {
        for (String key : this.keyFieldMap.keySet()) {
            if (!newProperties.containsKey(key) || newProperties.get(key) != this.getNotSetConstant() || this.keyFieldMap.get(key).getAnnotation(ConfigurationProperty.class).isUnsetable()) continue;
            throw new IllegalArgumentException("Tried to unset a field which is not declared unsetable");
        }
        super.setProperties(newProperties);
    }
}

