/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.datastream.configurable;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyConfigurable;
import org.palladiosimulator.edp2.datastream.configurable.IPropertyListener;

public abstract class PropertyConfigurable
extends AbstractObservable<IPropertyListener>
implements IPropertyConfigurable {
    public static final Object NOT_SET = new Object();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    protected final Set<String> keys = this.getKeys();

    public PropertyConfigurable() {
    }

    public PropertyConfigurable(Map<String, Object> newProperties) {
        this();
        this.setProperties(newProperties);
    }

    public abstract Map<String, Object> getDefaultConfiguration();

    @Override
    public abstract Set<String> getKeys();

    @Override
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void setProperties(Map<String, Object> newProperties) {
        for (String key : this.keys) {
            Class propertyType;
            Class<?> fromClass;
            if (!newProperties.containsKey(key)) {
                throw new IllegalArgumentException("New properties miss expected key " + key);
            }
            if (newProperties.get(key) == null) {
                throw new IllegalArgumentException("New properties has null value for key " + key);
            }
            if (newProperties.get(key) == NOT_SET || ClassUtils.isAssignable(fromClass = newProperties.get(key).getClass(), (Class)(propertyType = this.getPropertyType(key)), (boolean)true)) continue;
            throw new IllegalArgumentException("New properties have wrong type for " + key);
        }
        for (String key : this.keys) {
            Object oldValue = this.properties.get(key);
            Object newValue = newProperties.get(key);
            this.properties.put(key, newProperties.get(key));
            if ((newValue != null || oldValue == null) && (newValue == null || newValue.equals(oldValue))) continue;
            ((IPropertyListener)this.getEventDispatcher()).propertyChanged(key, oldValue, newValue);
        }
        ((IPropertyListener)this.getEventDispatcher()).propertyChangeCompleted();
    }

    @Override
    public boolean isPropertyNotSet(String key) {
        return this.properties.get(key) == NOT_SET;
    }

    @Override
    public void unsetProperty(String key) {
        this.properties.put(key, NOT_SET);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return null;
    }

    protected Object getNotSetConstant() {
        return NOT_SET;
    }
}

