/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.distancemetrics.ui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.palladiosimulator.edp2.distancemetrics.ui.DistanceMetricExtensionHandler;
import org.palladiosimulator.edp2.distancemetrics.ui.extensions.DistanceMetricExtension;
import org.palladiosimulator.edp2.distancemetrics.ui.extensions.properties.PropertyAccess;
import org.palladiosimulator.edp2.visualization.Activator;

public class ComboListener
implements SelectionListener {
    private Combo comboDropDown;
    private DistanceMetricExtensionHandler dmeHandler;
    private Group groupProperties;
    private Composite composite;
    private TabbedPropertySheetPage aTabbedPropertySheetPage;
    private Composite currentProps = null;
    private Text descriptionText;

    ComboListener(Combo comboDropDown, DistanceMetricExtensionHandler dmeHandler, Composite composite, TabbedPropertySheetPage aTabbedPropertySheetPage, Text descriptionText) {
        this.comboDropDown = comboDropDown;
        this.dmeHandler = dmeHandler;
        this.composite = composite;
        this.aTabbedPropertySheetPage = aTabbedPropertySheetPage;
        this.descriptionText = descriptionText;
    }

    public void widgetSelected(SelectionEvent event) {
        DistanceMetricExtension dme;
        if (this.comboDropDown.getSelectionIndex() == -1) {
            MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No distance metric algorithm selected", (String)"Please select a distance metric algorithm from the drop down menu.");
        } else {
            dme = this.dmeHandler.getDistanceMetricExtensionList().get(this.comboDropDown.getSelectionIndex());
            if (this.groupProperties != null) {
                this.groupProperties.dispose();
            }
            if (dme instanceof PropertyAccess) {
                this.createProperties((PropertyAccess)((Object)dme));
            }
            this.aTabbedPropertySheetPage.resizeScrolledComposite();
        }
        dme = this.dmeHandler.getDistanceMetricExtensionList().get(this.comboDropDown.getSelectionIndex());
        this.descriptionText.setText(dme.getDistanceMetricDescription());
    }

    private void createProperties(PropertyAccess pa) {
        this.groupProperties = new Group(this.composite, 256);
        this.groupProperties.setText("Properties");
        this.groupProperties.setLayout((Layout)new GridLayout(1, false));
        if (this.currentProps != null) {
            this.currentProps.dispose();
        }
        this.currentProps = pa.getPropertiesWidget((Composite)this.groupProperties, 0);
        this.composite.layout();
        this.composite.update();
        this.composite.redraw();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

