/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.distancemetrics.ui;

import java.util.logging.Logger;
import javax.measure.quantity.Quantity;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.distancemetrics.ui.DistanceMetricExtensionHandler;
import org.palladiosimulator.edp2.distancemetrics.ui.DistanceMetricViewer;
import org.palladiosimulator.edp2.distancemetrics.ui.extensions.DistanceMetricExtension;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.Activator;
import org.palladiosimulator.measurementframework.TupleMeasurement;

public class CalculateButtonListener
implements Listener {
    private static final Logger LOGGER = Logger.getLogger(CalculateButtonListener.class.getCanonicalName());
    private DistanceMetricViewer dmViewer1;
    private DistanceMetricViewer dmViewer2;
    private Button buttonCalculateDistance;
    private Combo comboDropDown;
    private DistanceMetricExtensionHandler dmeHandler;
    private Text resultText;

    CalculateButtonListener(DistanceMetricViewer dmViewer1, DistanceMetricViewer dmViewer2, Button buttonCalculateDistance, Combo comboDropDown, Text resultText, DistanceMetricExtensionHandler dmeHandler) {
        this.dmViewer1 = dmViewer1;
        this.dmViewer2 = dmViewer2;
        this.buttonCalculateDistance = buttonCalculateDistance;
        this.comboDropDown = comboDropDown;
        this.resultText = resultText;
        this.dmeHandler = dmeHandler;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.buttonCalculateDistance) {
            IStructuredSelection selection1 = this.dmViewer1.getViewer().getStructuredSelection();
            AbstractVisualizationSingleDatastreamInput lastSelectedInput1 = (AbstractVisualizationSingleDatastreamInput)selection1.getFirstElement();
            IStructuredSelection selection2 = this.dmViewer2.getViewer().getStructuredSelection();
            AbstractVisualizationSingleDatastreamInput lastSelectedInput2 = (AbstractVisualizationSingleDatastreamInput)selection2.getFirstElement();
            if (lastSelectedInput1 != null && lastSelectedInput2 != null) {
                lastSelectedInput1.getDataSource();
                Edp2DataTupleDataSource dataSource1 = (Edp2DataTupleDataSource)lastSelectedInput1.getDataSource();
                Edp2DataTupleDataSource dataSource2 = (Edp2DataTupleDataSource)lastSelectedInput2.getDataSource();
                IDataStream stream1 = dataSource1.getDataStream();
                IDataStream stream2 = dataSource2.getDataStream();
                LOGGER.info("Selected index: " + this.comboDropDown.getSelectionIndex());
                if (this.comboDropDown.getSelectionIndex() == -1) {
                    MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No distance metric algorithm selected", (String)"Please select a distance metric algorithm from the drop down menu.");
                } else {
                    DistanceMetricExtension dme = this.dmeHandler.getDistanceMetricExtensionList().get(this.comboDropDown.getSelectionIndex());
                    this.buttonCalculateDistance.setEnabled(false);
                    this.executeDM(dme, (IDataStream<TupleMeasurement>)stream1, (IDataStream<TupleMeasurement>)stream2);
                }
            } else {
                MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No data series selected", (String)"Please select two data series to compare with.");
            }
        }
    }

    private void executeDM(final DistanceMetricExtension dme, final IDataStream<TupleMeasurement> stream1, final IDataStream<TupleMeasurement> stream2) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable e) {
                LOGGER.info("Exception in execution of distance metric algorithm. The DistanceMetric Extension to execute might not work properly.");
            }

            public void run() throws Exception {
                Amount<? extends Quantity> result = dme.calculateDistance((IDataStream<TupleMeasurement>)stream1, (IDataStream<TupleMeasurement>)stream2);
                if (result != null) {
                    LOGGER.info("Calculated distance of the two selected measurements is: " + result.toString());
                    CalculateButtonListener.this.resultText.setText(result.toString());
                } else {
                    LOGGER.info("Calculation could not be executeed. Something went wrong here!");
                }
                CalculateButtonListener.this.buttonCalculateDistance.setEnabled(true);
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }
}

