/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.distancemetrics;

import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.distancemetrics.DistanceMetric;
import org.palladiosimulator.edp2.distancemetrics.util.Utility;
import org.palladiosimulator.measurementframework.TupleMeasurement;

public class DynamicTimeWarping
implements DistanceMetric {
    private int window = 50;

    public Amount<?> calculateDistance(IDataStream<TupleMeasurement> s1, IDataStream<TupleMeasurement> s2) {
        int j;
        Utility.legalStreamComparison(s1, s2);
        int numOfElements1 = s1.size();
        int numOfElements2 = s2.size();
        Amount<?>[] s = Utility.streamToArray(s1);
        Amount<?>[] t = Utility.streamToArray(s2);
        Unit<Quantity> valueBaseUnit = Utility.getBaseValueUnit(s1);
        Utility.parametersAllowed(numOfElements1, numOfElements2);
        if (numOfElements1 == 0 || numOfElements2 == 0) {
            return Amount.valueOf((double)0.0, valueBaseUnit);
        }
        Amount[][] dtw = new Amount[numOfElements1 + 1][numOfElements2 + 1];
        int i = 0;
        while (i <= numOfElements1) {
            j = 0;
            while (j < numOfElements2 + 1) {
                dtw[i][j] = Amount.valueOf((double)Double.POSITIVE_INFINITY, valueBaseUnit);
                ++j;
            }
            ++i;
        }
        dtw[0][0] = Amount.valueOf((double)0.0, valueBaseUnit);
        i = 1;
        while (i <= numOfElements1) {
            j = Math.max(1, i - this.window);
            while (j < Math.min(numOfElements2 + 1, i + this.window)) {
                Amount<? extends Quantity> cost = Utility.euclid(s[i - 1], t[j - 1]);
                Amount minCost = Amount.valueOf((double)Math.min(dtw[i - 1][j].doubleValue(valueBaseUnit), Math.min(dtw[i][j - 1].doubleValue(valueBaseUnit), dtw[i - 1][j - 1].doubleValue(valueBaseUnit))), valueBaseUnit);
                dtw[i][j] = cost.plus(minCost);
                ++j;
            }
            ++i;
        }
        return dtw[numOfElements1][numOfElements2];
    }

    public void setWindow(int window) {
        this.window = window;
    }
}

