/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.distancemetrics.util;

import java.util.Iterator;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.eclipse.emf.common.util.EList;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.distancemetrics.util.TupleWrapper;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;

public class Utility {
    public static final double DELTA = 1.0E-7;

    public static void legalStreamComparison(IDataStream<TupleMeasurement> s1, IDataStream<TupleMeasurement> s2) {
        boolean isLegal = MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)s1.getMetricDesciption(), (MetricDescription)s2.getMetricDesciption());
        if (!isLegal) {
            throw new IllegalArgumentException("Streams to compare don't contain same metric.");
        }
    }

    public static Unit<Quantity> getBaseTimeUnit(IDataStream<TupleMeasurement> stream) {
        EList subsumedMetrics = ((MetricSetDescription)stream.getMetricDesciption()).getSubsumedMetrics();
        Unit domainUnit = ((NumericalBaseMetricDescription)subsumedMetrics.get(0)).getDefaultUnit();
        return domainUnit;
    }

    public static Unit<Quantity> getBaseValueUnit(IDataStream<TupleMeasurement> stream) {
        EList subsumedMetrics = ((MetricSetDescription)stream.getMetricDesciption()).getSubsumedMetrics();
        Unit domainUnit = ((NumericalBaseMetricDescription)subsumedMetrics.get(1)).getDefaultUnit();
        return domainUnit;
    }

    public static boolean compareEquals(double v1, double v2) {
        return Math.abs(v1 - v2) <= 1.0E-7;
    }

    public static <U extends Quantity> Amount<U> quantityToAmount(Measure<?, U> measure) {
        return Amount.valueOf((double)measure.doubleValue(measure.getUnit()), (Unit)measure.getUnit());
    }

    public static double euclid(double v1, double v2) {
        return Math.abs(v1 - v2);
    }

    public static Amount<? extends Quantity> euclid(Amount<?> amount, Amount<?> amount2) {
        return amount.minus(amount2).abs();
    }

    public static Amount<?>[] streamToArray(IDataStream<TupleMeasurement> stream) {
        Amount[] array = new Amount[stream.size()];
        Iterator it = stream.iterator();
        int i = 0;
        while (i < stream.size()) {
            Measure measure = ((TupleMeasurement)it.next()).asArray()[1];
            Unit<Quantity> unit = Utility.getBaseValueUnit(stream);
            double measureDouble = measure.doubleValue(Utility.getBaseValueUnit(stream));
            array[i] = Amount.valueOf((double)measureDouble, unit);
            ++i;
        }
        return array;
    }

    public static TupleWrapper[] streamToTupleWrapperArray(IDataStream<TupleMeasurement> stream) {
        TupleWrapper[] array = new TupleWrapper[stream.size()];
        Iterator it = stream.iterator();
        int i = 0;
        while (i < stream.size()) {
            array[i] = new TupleWrapper((TupleMeasurement)it.next());
            ++i;
        }
        return array;
    }

    public static double[] streamToDoubleArray(IDataStream<TupleMeasurement> stream) {
        double[] array = new double[stream.size()];
        Iterator it = stream.iterator();
        int i = 0;
        while (i < stream.size()) {
            Measure measure = ((TupleMeasurement)it.next()).asArray()[1];
            array[i] = measure.doubleValue(Utility.getBaseValueUnit(stream));
            ++i;
        }
        return array;
    }

    public static TupleMeasurement[] streamToTupleArray(IDataStream<TupleMeasurement> stream) {
        TupleMeasurement[] array = new TupleMeasurement[stream.size()];
        Iterator it = stream.iterator();
        int i = 0;
        while (i < stream.size()) {
            array[i] = (TupleMeasurement)it.next();
            ++i;
        }
        return array;
    }

    public static void parametersAllowed(int numOfElements1, int numOfElements2) {
        if (numOfElements1 > Integer.MAX_VALUE || numOfElements2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Stream is bigger than Integer.MAX_VALUE.");
        }
        if (numOfElements1 < 0 || numOfElements2 < 0) {
            throw new IllegalArgumentException("Number of elements is negative.");
        }
    }

    public static double linearInterpolation(double[] x, double[] y, double xi) {
        LinearInterpolator li = new LinearInterpolator();
        PolynomialSplineFunction psf = li.interpolate(x, y);
        double yi = psf.value(xi);
        return yi;
    }
}

