/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.distancemetrics;

import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.distancemetrics.DistanceMetric;
import org.palladiosimulator.edp2.distancemetrics.util.Utility;
import org.palladiosimulator.measurementframework.TupleMeasurement;

public class EditDistanceOnRealSequence
implements DistanceMetric {
    private final double initialEpsilon = 25.0;
    private final double initialSubcost = 1.0;
    private double epsilon = 25.0;
    private double subcost = 1.0;

    public Amount<?> calculateDistance(IDataStream<TupleMeasurement> s1, IDataStream<TupleMeasurement> s2) {
        Utility.legalStreamComparison(s1, s2);
        int numOfElements1 = s1.size();
        int numOfElements2 = s2.size();
        Amount<?>[] s = Utility.streamToArray(s1);
        Amount<?>[] t = Utility.streamToArray(s2);
        Unit<Quantity> valueBaseUnit = Utility.getBaseValueUnit(s1);
        Utility.parametersAllowed(numOfElements1, numOfElements2);
        Utility.getBaseValueUnit(s1);
        if (numOfElements1 == 0 && numOfElements2 == 0) {
            return Amount.valueOf((double)0.0, valueBaseUnit);
        }
        if (numOfElements1 == 0) {
            return Amount.valueOf((double)numOfElements2, valueBaseUnit);
        }
        if (numOfElements2 == 0) {
            return Amount.valueOf((double)numOfElements1, valueBaseUnit);
        }
        int[][] edr = new int[numOfElements1 + 1][numOfElements2 + 1];
        edr[0][0] = 0;
        int i = 1;
        while (i < numOfElements1 + 1) {
            edr[i][0] = i;
            ++i;
        }
        int j = 1;
        while (j < numOfElements2 + 1) {
            edr[0][j] = j;
            ++j;
        }
        i = 1;
        while (i < numOfElements1 + 1) {
            int j2 = 1;
            while (j2 < numOfElements2 + 1) {
                double result = this.calcSubcost(s[i - 1], t[j2 - 1], this.epsilon);
                edr[i][j2] = (int)Math.min((double)(edr[i - 1][j2] + 1), Math.min((double)edr[i][j2 - 1], (double)edr[i - 1][j2 - 1] + result));
                ++j2;
            }
            ++i;
        }
        return Amount.valueOf((long)edr[numOfElements1][numOfElements2], valueBaseUnit);
    }

    private double calcSubcost(Amount<?> a1, Amount<?> a2, double epsilon) {
        if (this.match(a1, a2, epsilon)) {
            return 0.0;
        }
        return this.subcost;
    }

    private boolean match(Amount<?> a1, Amount<?> a2, double epsilon) {
        return Math.abs(a1.getEstimatedValue() - a2.getEstimatedValue()) <= epsilon;
    }

    public void setEpsilon(double e) {
        this.epsilon = e;
    }

    public void setSubcost(double subcost) {
        this.subcost = subcost;
    }

    public double getInitialEpsilon() {
        return 25.0;
    }
}

