/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.example;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.edp2.dao.MeasurementsDao;
import org.palladiosimulator.edp2.example.StoreExample;
import org.palladiosimulator.edp2.models.ExperimentData.DataSeries;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataFactory;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.MeasuringType;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.edp2.models.measuringpoint.StringMeasuringPoint;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.measurementframework.measure.IdentifierMeasure;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.CaptureType;
import org.palladiosimulator.metricspec.DataType;
import org.palladiosimulator.metricspec.Description;
import org.palladiosimulator.metricspec.Identifier;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.PersistenceKindOptions;
import org.palladiosimulator.metricspec.Scale;
import org.palladiosimulator.metricspec.TextualBaseMetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.metricspec.util.builder.IdentifierBuilder;
import org.palladiosimulator.metricspec.util.builder.MetricSetDescriptionBuilder;
import org.palladiosimulator.metricspec.util.builder.NumericalBaseMetricDescriptionBuilder;
import org.palladiosimulator.metricspec.util.builder.TextualBaseMetricDescriptionBuilder;

public class ExampleData {
    private static final Logger LOGGER = Logger.getLogger(StoreExample.class.getCanonicalName());
    private static final Unit<Dimensionless> NUMBER_OF_THREADS_UNIT = new BaseUnit("Threads");
    public static final String AbsoluteFrequencyUUID = "_AiroIZMbEd6Vw8NDgVSYcg";
    public static final String ArchitectureQualityEstimationUUID = "_lss1MEhpEd-SQI4N8E0NHA";
    public static final String ArchitectureQualityEstimationLowUUID = "_BRpvcEigEd-uCvl0Z-GteQ";
    public static final String ArchitectureQualityEstimationMediumUUID = "_JYesoEigEd-4XZQqGmj8Pg";
    public static final String ArchitectureQualityEstimationHighUUID = "_LCpvcEigEd-s193kEND-BA";
    public final BaseMetricDescription absoluteFrequency;
    public final TextualBaseMetricDescription architectureQualityEstimation;
    public final MetricSetDescription serviceCallARTMetric;
    public final Identifier architectureQualityIdentifierLow;
    public final Identifier architectureQualityIdentifierMedium;
    public final Identifier architectureQualityIdentifierHigh;
    private ExperimentGroup groupA;
    private MeasuringType serviceCallA;
    private MeasuringType cpuA;
    private MeasuringType architectureQualityA;
    private ExperimentSetting settingA;
    private ExperimentRun runA0;
    private Measurement measurementServiceCallA;
    private Measurement measurementArchitectureQuality;
    private MeasurementRange range;
    private RawMeasurements rawMeasurements;
    private final ExperimentDataFactory EXPERIMENT_DATA_FACTORY = ExperimentDataFactory.eINSTANCE;
    private final MeasuringpointFactory MEASURING_POINT_FACTORY = MeasuringpointFactory.eINSTANCE;

    public ExampleData(EList<Description> existingDescriptions) {
        this.absoluteFrequency = this.checkExistingNumericalBaseMetricDescription(existingDescriptions, AbsoluteFrequencyUUID, "Frequency", "Absolute frequency of measurements or events. For example, of measurements lying within an interval of a histogram.", CaptureType.INTEGER_NUMBER, Scale.RATIO, NUMBER_OF_THREADS_UNIT, DataType.QUANTITATIVE);
        this.architectureQualityEstimation = this.checkExistingTextualBaseMetricDescription(existingDescriptions, ArchitectureQualityEstimationUUID, "Architecture Quality Estimation", "Expresses a subjective expert estimation on a software architecture's overall quality.", Scale.ORDINAL, DataType.QUALITATIVE);
        this.architectureQualityIdentifierLow = this.checkExistingIdentifier(this.architectureQualityEstimation, ArchitectureQualityEstimationLowUUID, "Low");
        this.architectureQualityIdentifierMedium = this.checkExistingIdentifier(this.architectureQualityEstimation, ArchitectureQualityEstimationMediumUUID, "Medium");
        this.architectureQualityIdentifierHigh = this.checkExistingIdentifier(this.architectureQualityEstimation, ArchitectureQualityEstimationHighUUID, "High");
        this.serviceCallARTMetric = this.checkExistingMetricSetDescription(existingDescriptions, "_LCpvcEigEd-s193kEND-BE", "RT of Call A", "RT of call A", (BaseMetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC, MetricDescriptionConstants.RESPONSE_TIME_METRIC);
        this.architectureQualityEstimation.getIdentifiers().addAll(Arrays.asList(this.architectureQualityIdentifierLow, this.architectureQualityIdentifierMedium, this.architectureQualityIdentifierHigh));
    }

    private MetricSetDescription checkExistingMetricSetDescription(EList<Description> existingDescriptions, String uuid, String name, String textualDescription, BaseMetricDescription submetric1, BaseMetricDescription submetric2) {
        Description description2;
        if (existingDescriptions != null) {
            for (Description description2 : existingDescriptions) {
                if (!description2.getId().equals(uuid)) continue;
                return (MetricSetDescription)description2;
            }
        }
        description2 = MetricSetDescriptionBuilder.newMetricSetDescriptionBuilder().name(name).textualDescription(textualDescription).id(uuid).subsumedMetrics((MetricDescription)submetric1).subsumedMetrics((MetricDescription)submetric2).build();
        existingDescriptions.add((Object)description2);
        return description2;
    }

    private NumericalBaseMetricDescription checkExistingNumericalBaseMetricDescription(EList<Description> existingDescriptions, String uuid, String name, String textualDescription, CaptureType captureType, Scale scale, Unit<?> defaultUnit, DataType dataType) {
        Description description2;
        if (existingDescriptions != null) {
            for (Description description2 : existingDescriptions) {
                if (!description2.getId().equals(uuid)) continue;
                return (NumericalBaseMetricDescription)description2;
            }
        }
        description2 = NumericalBaseMetricDescriptionBuilder.newNumericalBaseMetricDescriptionBuilder().name(name).textualDescription(textualDescription).captureType(captureType).scale(scale).dataType(dataType).defaultUnit(defaultUnit).persistenceKind(PersistenceKindOptions.BINARY_PREFERRED).id(uuid).build();
        existingDescriptions.add((Object)description2);
        return description2;
    }

    private TextualBaseMetricDescription checkExistingTextualBaseMetricDescription(EList<Description> existingDescriptions, String uuid, String name, String textualDescription, Scale scale, DataType dataType) {
        Description description2;
        if (existingDescriptions != null) {
            for (Description description2 : existingDescriptions) {
                if (!description2.getId().equals(uuid)) continue;
                return (TextualBaseMetricDescription)description2;
            }
        }
        description2 = TextualBaseMetricDescriptionBuilder.newTextualBaseMetricDescriptionBuilder().name(name).textualDescription(textualDescription).scale(scale).dataType(dataType).id(uuid).build();
        existingDescriptions.add((Object)description2);
        return description2;
    }

    private Identifier checkExistingIdentifier(TextualBaseMetricDescription description, String uuid, String literal) {
        if (description != null) {
            Identifier identifier2;
            for (Identifier identifier2 : description.getIdentifiers()) {
                if (!identifier2.getId().equals(uuid)) continue;
                return identifier2;
            }
            identifier2 = IdentifierBuilder.newIdentifierBuilder().id(uuid).literal(literal).build();
            description.getIdentifiers().add((Object)identifier2);
            return identifier2;
        }
        throw new IllegalArgumentException("Description must not be null.");
    }

    public void createExampleExperimentMetadata() {
        StringMeasuringPoint serviceCallAMeasuringPoint = this.MEASURING_POINT_FACTORY.createStringMeasuringPoint();
        serviceCallAMeasuringPoint.setMeasuringPoint("Service Call A");
        StringMeasuringPoint cpuAMeasuringPoint = this.MEASURING_POINT_FACTORY.createStringMeasuringPoint();
        serviceCallAMeasuringPoint.setMeasuringPoint("CPU A");
        StringMeasuringPoint architectureAMeasuringPoint = this.MEASURING_POINT_FACTORY.createStringMeasuringPoint();
        serviceCallAMeasuringPoint.setMeasuringPoint("Architecture A");
        this.serviceCallA = this.EXPERIMENT_DATA_FACTORY.createMeasuringType((MeasuringPoint)serviceCallAMeasuringPoint, (MetricDescription)this.serviceCallARTMetric);
        this.cpuA = this.EXPERIMENT_DATA_FACTORY.createMeasuringType((MeasuringPoint)cpuAMeasuringPoint, (MetricDescription)MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_OVER_TIME_METRIC);
        this.architectureQualityA = this.EXPERIMENT_DATA_FACTORY.createMeasuringType((MeasuringPoint)architectureAMeasuringPoint, (MetricDescription)this.architectureQualityEstimation);
        this.groupA = this.EXPERIMENT_DATA_FACTORY.createExperimentGroup("Exemplary use of EDP2");
        this.groupA.getMeasuringTypes().add((Object)this.serviceCallA);
        this.groupA.getMeasuringTypes().add((Object)this.cpuA);
        this.groupA.getMeasuringTypes().add((Object)this.architectureQualityA);
        this.settingA = this.EXPERIMENT_DATA_FACTORY.createExperimentSetting(this.groupA, "Experiment Setting #1");
        this.settingA.getMeasuringTypes().add((Object)this.serviceCallA);
        this.settingA.getMeasuringTypes().add((Object)this.cpuA);
        this.settingA.getMeasuringTypes().add((Object)this.architectureQualityA);
        LOGGER.info("Example metadata created.");
    }

    public ExperimentGroup getExampleExperimentGroup() {
        return this.groupA;
    }

    private void prepareExperimentRunForSettingA() {
        this.runA0 = this.EXPERIMENT_DATA_FACTORY.createExperimentRun(this.settingA);
        this.measurementServiceCallA = this.EXPERIMENT_DATA_FACTORY.createMeasurement(this.serviceCallA);
        this.runA0.getMeasurement().add((Object)this.measurementServiceCallA);
        this.range = this.EXPERIMENT_DATA_FACTORY.createMeasurementRange(this.measurementServiceCallA);
        this.rawMeasurements = this.EXPERIMENT_DATA_FACTORY.createRawMeasurements(this.range);
        MeasurementsUtility.createDAOsForRawMeasurements((RawMeasurements)this.rawMeasurements);
        this.measurementArchitectureQuality = this.EXPERIMENT_DATA_FACTORY.createMeasurement(this.architectureQualityA);
        this.runA0.getMeasurement().add((Object)this.measurementArchitectureQuality);
        MeasurementsUtility.createDAOsForRawMeasurements((RawMeasurements)this.EXPERIMENT_DATA_FACTORY.createRawMeasurements(this.EXPERIMENT_DATA_FACTORY.createMeasurementRange(this.measurementArchitectureQuality)));
        LOGGER.info("Experiment run for setting A prepared.");
    }

    private void runExperimentForSettingA() {
        BasicMeasurement measurement;
        this.runA0.setStartTime(new Date());
        Random random = new Random();
        int i = 0;
        while (i < 1000) {
            measurement = new TupleMeasurement((MetricSetDescription)this.measurementServiceCallA.getMeasuringType().getMetric(), new Measure[]{Measure.valueOf((double)i, (Unit)SI.SECOND), Measure.valueOf((double)(random.nextDouble() * 10.0), (Unit)SI.SECOND)});
            MeasurementsUtility.storeMeasurement((Measurement)this.measurementServiceCallA, (MeasuringValue)measurement);
            ++i;
        }
        LOGGER.info("Measurements for service call A generated.");
        measurement = new BasicMeasurement((Measure)new IdentifierMeasure(this.architectureQualityIdentifierLow, Unit.ONE), (BaseMetricDescription)this.measurementArchitectureQuality.getMeasuringType().getMetric());
        MeasurementsUtility.storeMeasurement((Measurement)this.measurementArchitectureQuality, (MeasuringValue)measurement);
        LOGGER.info("Measurements for architecture quality A generated.");
    }

    public void simulateExperimentRun() {
        this.prepareExperimentRunForSettingA();
        this.runExperimentForSettingA();
        LOGGER.info("Experiment run finished. Example data created.");
    }

    public String printStoredMeasurements(Repository repo, String experimentGroupUuid) {
        try {
            String result = "";
            for (ExperimentGroup group : repo.getExperimentGroups()) {
                if (!group.getId().equals(experimentGroupUuid)) continue;
                EList dataSeries = ((MeasurementRange)((Measurement)((ExperimentRun)((ExperimentSetting)group.getExperimentSettings().get(0)).getExperimentRuns().get(0)).getMeasurement().get(0)).getMeasurementRanges().get(0)).getRawMeasurements().getDataSeries();
                MeasurementsDao omdSeries1 = MeasurementsUtility.getMeasurementsDao((DataSeries)((DataSeries)dataSeries.get(0)));
                MeasurementsDao omdSeries2 = MeasurementsUtility.getMeasurementsDao((DataSeries)((DataSeries)dataSeries.get(1)));
                result = String.valueOf(result) + "Stored service call example data\n";
                result = String.valueOf(result) + "--------------------------------\n\n";
                MetricSetDescription md = (MetricSetDescription)((DataSeries)dataSeries.get(0)).getRawMeasurements().getMeasurementRange().getMeasurement().getMeasuringType().getMetric();
                result = String.valueOf(result) + ((MetricDescription)md.getSubsumedMetrics().get(0)).getName() + "\t" + ((MetricDescription)md.getSubsumedMetrics().get(1)).getName() + "\n";
                List list1 = omdSeries1.getMeasurements();
                List list2 = omdSeries2.getMeasurements();
                int pos = 0;
                while (pos < list1.size()) {
                    result = String.valueOf(result) + list1.get(pos) + "\t" + list2.get(pos) + "\n";
                    ++pos;
                }
                dataSeries = ((MeasurementRange)((Measurement)((ExperimentRun)((ExperimentSetting)group.getExperimentSettings().get(0)).getExperimentRuns().get(0)).getMeasurement().get(1)).getMeasurementRanges().get(0)).getRawMeasurements().getDataSeries();
                MeasurementsDao nmd = MeasurementsUtility.getMeasurementsDao((DataSeries)((DataSeries)dataSeries.get(0)));
                result = String.valueOf(result) + "Architecture Quality Estimation was: " + ((Identifier)((Measure)nmd.getMeasurements().get(0)).getValue()).getLiteral();
            }
            return result;
        }
        catch (NullPointerException npe) {
            LOGGER.log(Level.SEVERE, "Access to created example measurements failed. The data is either not created by the example code or there are store/load errors.");
            return "";
        }
    }

    public String printStoredMeasurements(Repository repo) {
        return this.printStoredMeasurements(repo, this.groupA.getId());
    }
}

