/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.example;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.example.ExampleData;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.local.LocalDirectoryRepository;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.Repository.Repositories;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.repository.local.LocalDirectoryRepositoryHelper;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.metricspec.Description;

public class LoadExample {
    public static String DEFAULT_DIRECTORY = "LocalRepository";
    private static final Logger LOGGER = Logger.getLogger(LoadExample.class.getCanonicalName());
    private final ExampleData exampleData;
    private final Repository ldRepo;

    public LoadExample() {
        this(DEFAULT_DIRECTORY);
    }

    public LoadExample(String directory) {
        this.initPathmaps();
        this.ldRepo = this.initializeRepository(directory);
        this.exampleData = new ExampleData((EList<Description>)this.ldRepo.getDescriptions());
    }

    private Repository initializeRepository(String directory) {
        LocalDirectoryRepository repo = LocalDirectoryRepositoryHelper.initializeLocalDirectoryRepository((File)new File(directory));
        RepositoryManager.addRepository((Repositories)RepositoryManager.getCentralRepository(), (Repository)repo);
        return repo;
    }

    private void initPathmaps() {
        String metricSpecModel = "models/commonMetrics.metricspec";
        URL url = this.getClass().getClassLoader().getResource("models/commonMetrics.metricspec");
        if (url == null) {
            throw new RuntimeException("Error getting common metric definitions");
        }
        String urlString = url.toString();
        if (!urlString.endsWith("models/commonMetrics.metricspec")) {
            throw new RuntimeException("Error getting common metric definitions. Got: " + urlString);
        }
        urlString = urlString.substring(0, urlString.length() - "models/commonMetrics.metricspec".length() - 1);
        URI uri = URI.createURI((String)urlString);
        URI target = uri.appendSegment("models").appendSegment("");
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://METRIC_SPEC_MODELS/"), target);
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("metricspec", new XMIResourceFactoryImpl());
    }

    public void run() {
        try {
            MeasurementsUtility.ensureOpenRepository((Repository)this.ldRepo);
            System.out.println(this.exampleData.printStoredMeasurements(this.ldRepo, ((ExperimentGroup)this.ldRepo.getExperimentGroups().get(this.ldRepo.getExperimentGroups().size() - 1)).getId()));
            MeasurementsUtility.ensureClosedRepository((Repository)this.ldRepo);
        }
        catch (DataNotAccessibleException e) {
            LOGGER.log(Level.SEVERE, "Error while accessing the datastore.", e);
        }
    }

    public static void main(String[] args) {
        LoadExample example = new LoadExample();
        example.run();
    }
}

