/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.example;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.datastream.filter.AbstractFilter;
import org.palladiosimulator.edp2.example.ExampleData;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.MeasuringType;
import org.palladiosimulator.edp2.models.Repository.LocalMemoryRepository;
import org.palladiosimulator.edp2.models.Repository.Repositories;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.models.Repository.RepositoryFactory;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.metricspec.Description;
import org.palladiosimulator.metricspec.MetricSetDescription;

public class StoreLoadExample {
    public static final String DEFAULT_DIRECTORY = "LocalRepository";
    private static final Logger LOGGER = Logger.getLogger(StoreLoadExample.class.getCanonicalName());
    private final Repository ldRepo;
    private final ExampleData exampleData;

    public StoreLoadExample() {
        this(DEFAULT_DIRECTORY);
    }

    public StoreLoadExample(String directory) {
        this.initPathmaps();
        this.ldRepo = this.initializeRepository(directory);
        this.exampleData = new ExampleData((EList<Description>)this.ldRepo.getDescriptions());
    }

    private void initPathmaps() {
        String metricSpecModel = "commonMetrics.metricspec";
        URL url = this.getClass().getClassLoader().getResource("commonMetrics.metricspec");
        if (url == null) {
            throw new RuntimeException("Error getting common metric definitions");
        }
        String urlString = url.toString();
        if (!urlString.endsWith("commonMetrics.metricspec")) {
            throw new RuntimeException("Error getting common metric definitions. Got: " + urlString);
        }
        urlString = urlString.substring(0, urlString.length() - "commonMetrics.metricspec".length() - 1);
        URI uri = URI.createURI((String)urlString);
        URI target = uri.appendSegment("");
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://METRIC_SPEC_MODELS/"), target);
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("metricspec", new XMIResourceFactoryImpl());
    }

    private Repository initializeRepository(String directory) {
        LocalMemoryRepository repo = RepositoryFactory.eINSTANCE.createLocalMemoryRepository();
        RepositoryManager.addRepository((Repositories)RepositoryManager.getCentralRepository(), (Repository)repo);
        return repo;
    }

    private void createExample() {
        this.exampleData.createExampleExperimentMetadata();
        this.ldRepo.getExperimentGroups().add((Object)this.exampleData.getExampleExperimentGroup());
        this.exampleData.simulateExperimentRun();
    }

    public void run() {
        try {
            String storedData = this.storeExperimentRun();
            String readData = this.loadExperimentRun(storedData);
            if (readData != null && !readData.equals(storedData)) {
                throw new IllegalStateException("Stored and loaded data is not equal. Stored: " + storedData + "\nLoaded: " + readData);
            }
            this.streamResultData();
        }
        catch (DataNotAccessibleException e) {
            LOGGER.log(Level.SEVERE, "Error while accessing the datastore.", e);
        }
    }

    private void streamResultData() throws DataNotAccessibleException {
        MeasurementsUtility.ensureOpenRepository((Repository)this.ldRepo);
        Edp2DataTupleDataSource dataSource = new Edp2DataTupleDataSource(((MeasurementRange)((Measurement)((ExperimentRun)((ExperimentSetting)((ExperimentGroup)this.ldRepo.getExperimentGroups().get(0)).getExperimentSettings().get(0)).getExperimentRuns().get(0)).getMeasurement().get(0)).getMeasurementRanges().get(0)).getRawMeasurements());
        AbstractFilter adapter = new AbstractFilter((IDataSource)dataSource, ((MeasuringType)((ExperimentSetting)((ExperimentGroup)this.ldRepo.getExperimentGroups().get(0)).getExperimentSettings().get(0)).getMeasuringTypes().get(0)).getMetric()){

            protected MeasuringValue computeOutputFromInput(MeasuringValue data) {
                ArrayList<Measure> next = new ArrayList<Measure>(2);
                for (Measure m : data.asList()) {
                    Measure newM = Measure.valueOf((double)(m.doubleValue((Unit)SI.SECOND) + 1.0), (Unit)m.getUnit());
                    next.add(newM);
                }
                return new TupleMeasurement((MetricSetDescription)data.getMetricDesciption(), next);
            }
        };
        IDataStream dataStream = adapter.getDataStream();
        for (IMeasureProvider tuple : dataStream) {
            System.out.println(tuple);
        }
        dataStream.close();
        MeasurementsUtility.ensureClosedRepository((Repository)this.ldRepo);
    }

    private String loadExperimentRun(String storedData) throws DataNotAccessibleException {
        MeasurementsUtility.ensureOpenRepository((Repository)this.ldRepo);
        String readData = this.exampleData.printStoredMeasurements(this.ldRepo);
        System.out.println(readData);
        MeasurementsUtility.ensureClosedRepository((Repository)this.ldRepo);
        return readData;
    }

    private String storeExperimentRun() throws DataNotAccessibleException {
        MeasurementsUtility.ensureOpenRepository((Repository)this.ldRepo);
        this.createExample();
        String storedData = this.exampleData.printStoredMeasurements(this.ldRepo);
        System.out.println(storedData);
        MeasurementsUtility.ensureClosedRepository((Repository)this.ldRepo);
        return storedData;
    }

    public static void main(String[] args) {
        StoreLoadExample example = new StoreLoadExample();
        example.run();
    }
}

