/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.example;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.edp2.dao.MeasurementsDao;
import org.palladiosimulator.edp2.example.StoreExample;
import org.palladiosimulator.edp2.models.ExperimentData.DataSeries;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataFactory;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataPackage;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.MeasuringType;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.CaptureType;
import org.palladiosimulator.metricspec.DataType;
import org.palladiosimulator.metricspec.Description;
import org.palladiosimulator.metricspec.Identifier;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.PersistenceKindOptions;
import org.palladiosimulator.metricspec.Scale;
import org.palladiosimulator.metricspec.TextualBaseMetricDescription;
import org.palladiosimulator.metricspec.util.builder.IdentifierBuilder;
import org.palladiosimulator.metricspec.util.builder.MetricSetDescriptionBuilder;
import org.palladiosimulator.metricspec.util.builder.NumericalBaseMetricDescriptionBuilder;
import org.palladiosimulator.metricspec.util.builder.TextualBaseMetricDescriptionBuilder;

public class PieChartExampleData {
    private static final Logger LOGGER = Logger.getLogger(StoreExample.class.getCanonicalName());
    private static final ExperimentDataPackage experimentDataPackage = ExperimentDataPackage.eINSTANCE;
    private final ExperimentDataFactory experimentDataFactory = ExperimentDataFactory.eINSTANCE;
    private final Unit<Duration> timeUnit = SI.SECOND;
    private final Unit<Dimensionless> numberUnit = new BaseUnit("Threads");
    public static final String SimTimeUUID = "_38mSASUPEd6gmLudJva2Dw";
    public static final String NumberOfActiveJobsUUID = "_fvrNghUQEd8fmLudJva3De";
    private BaseMetricDescription SimTime;
    private BaseMetricDescription NumberOfActiveJobs;
    private MetricSetDescription NumberOfActiveJobsSimulated;
    private ExperimentGroup groupA;
    private MeasuringType serviceCallA;
    private MeasuringType cpuA;
    private MeasuringType architectureQualityA;
    private ExperimentSetting settingA;
    private ExperimentRun runA0;
    private Measurement measurementServiceCallA;
    private Measurement measurementArchitectureQuality;
    private MeasurementRange range;
    private RawMeasurements rawMeasurements;

    public Collection<Description> getDescriptions() {
        Vector<Description> list = new Vector<Description>();
        list.add((Description)this.SimTime);
        list.add((Description)this.NumberOfActiveJobs);
        return list;
    }

    public Collection<MetricDescription> createExampleMetricSetDescriptions(EList<Description> existingDescriptions) {
        Vector<MetricDescription> newDescriptions = new Vector<MetricDescription>();
        this.NumberOfActiveJobsSimulated = this.checkExistingMetricSetDescription(existingDescriptions, newDescriptions, "_26mSASnPEt8gmLuDJva2Dw", "Number of active jobs (Simulated)", "The currently active number of jobs, determined in a simulation. Consists of the simulation time and a number corresponding to the amount of active jobs.", this.SimTime, this.NumberOfActiveJobs);
        LOGGER.info("Metric descriptions created.");
        return newDescriptions;
    }

    private MetricSetDescription checkExistingMetricSetDescription(EList<Description> existingDescriptions, Collection<MetricDescription> newDescriptions, String uuid, String name, String textualDescription, BaseMetricDescription submetric1, BaseMetricDescription submetric2) {
        Description description2;
        if (existingDescriptions != null) {
            for (Description description2 : existingDescriptions) {
                if (!description2.getId().equals(uuid)) continue;
                return (MetricSetDescription)description2;
            }
        }
        description2 = MetricSetDescriptionBuilder.newMetricSetDescriptionBuilder().name(name).textualDescription(textualDescription).id(uuid).subsumedMetrics((MetricDescription)submetric1).subsumedMetrics((MetricDescription)submetric2).build();
        newDescriptions.add((MetricDescription)description2);
        return description2;
    }

    private NumericalBaseMetricDescription checkExistingNumericalBaseMetricDescription(EList<Description> existingDescriptions, Collection<MetricDescription> newDescriptions, String uuid, String name, String textualDescription, CaptureType captureType, Scale scale, Unit<?> defaultUnit, DataType dataType) {
        Description description2;
        if (existingDescriptions != null) {
            for (Description description2 : existingDescriptions) {
                if (!description2.getId().equals(uuid)) continue;
                return (NumericalBaseMetricDescription)description2;
            }
        }
        description2 = NumericalBaseMetricDescriptionBuilder.newNumericalBaseMetricDescriptionBuilder().name(name).textualDescription(textualDescription).captureType(captureType).scale(scale).dataType(dataType).defaultUnit(defaultUnit).persistenceKind(PersistenceKindOptions.BINARY_PREFERRED).id(uuid).build();
        newDescriptions.add((MetricDescription)description2);
        return description2;
    }

    private TextualBaseMetricDescription checkExistingTextualBaseMetricDescription(EList<Description> existingDescriptions, Collection<MetricDescription> newDescriptions, String uuid, String name, String textualDescription, Scale scale, DataType dataType) {
        Description description2;
        if (existingDescriptions != null) {
            for (Description description2 : existingDescriptions) {
                if (!description2.getId().equals(uuid)) continue;
                return (TextualBaseMetricDescription)description2;
            }
        }
        description2 = TextualBaseMetricDescriptionBuilder.newTextualBaseMetricDescriptionBuilder().name(name).textualDescription(textualDescription).scale(scale).dataType(dataType).id(uuid).build();
        newDescriptions.add((MetricDescription)description2);
        return description2;
    }

    private Identifier checkExistingIdentifier(TextualBaseMetricDescription description, String uuid, String literal) {
        if (description != null) {
            Identifier identifier2;
            for (Identifier identifier2 : description.getIdentifiers()) {
                if (!identifier2.getId().equals(uuid)) continue;
                return identifier2;
            }
            identifier2 = IdentifierBuilder.newIdentifierBuilder().id(uuid).literal(literal).build();
            description.getIdentifiers().add((Object)identifier2);
            return identifier2;
        }
        throw new IllegalArgumentException("Description must not be null.");
    }

    public Collection<MetricDescription> createExampleBaseMetricDescriptions(EList<Description> existingDescriptions) {
        Vector<MetricDescription> newDescriptions = new Vector<MetricDescription>();
        this.SimTime = this.checkExistingNumericalBaseMetricDescription(existingDescriptions, newDescriptions, SimTimeUUID, "Simulation Time", "Time passed within a simulation. Starting with 0.0.", CaptureType.REAL_NUMBER, Scale.INTERVAL, this.timeUnit, DataType.QUANTITATIVE);
        this.NumberOfActiveJobs = this.checkExistingNumericalBaseMetricDescription(existingDescriptions, newDescriptions, NumberOfActiveJobsUUID, "Active Jobs", "Number of Jobs, the CPU is currently working on.", CaptureType.INTEGER_NUMBER, Scale.INTERVAL, this.numberUnit, DataType.QUANTITATIVE);
        return newDescriptions;
    }

    public void createExampleExperimentMetadata() {
        this.groupA = this.experimentDataFactory.createExperimentGroup("Exemplary use of EDP2");
        this.groupA.getMeasuringTypes().add((Object)this.serviceCallA);
        this.groupA.getMeasuringTypes().add((Object)this.cpuA);
        this.groupA.getMeasuringTypes().add((Object)this.architectureQualityA);
        this.settingA = this.experimentDataFactory.createExperimentSetting(this.groupA, "Experiment Setting #1");
        this.settingA.getMeasuringTypes().add((Object)this.serviceCallA);
        this.settingA.getMeasuringTypes().add((Object)this.cpuA);
        this.settingA.getMeasuringTypes().add((Object)this.architectureQualityA);
        LOGGER.info("Example metadata created.");
    }

    public ExperimentGroup getExampleExperimentGroup() {
        return this.groupA;
    }

    private void prepareExperimentRunForSettingA() {
        this.measurementServiceCallA = this.experimentDataFactory.createMeasurement(this.serviceCallA);
        this.runA0 = this.experimentDataFactory.createExperimentRun(this.settingA);
        this.runA0.getMeasurement().add((Object)this.measurementServiceCallA);
        this.range = this.experimentDataFactory.createMeasurementRange(this.measurementServiceCallA);
        this.rawMeasurements = this.experimentDataFactory.createRawMeasurements(this.range);
        MeasurementsUtility.createDAOsForRawMeasurements((RawMeasurements)this.rawMeasurements);
        this.measurementArchitectureQuality = this.experimentDataFactory.createMeasurement(this.architectureQualityA);
        this.runA0.getMeasurement().add((Object)this.measurementArchitectureQuality);
        MeasurementsUtility.createDAOsForRawMeasurements((RawMeasurements)this.experimentDataFactory.createRawMeasurements(this.experimentDataFactory.createMeasurementRange(this.measurementArchitectureQuality)));
        LOGGER.info("Experiment run for setting A prepared.");
    }

    private void runExperimentForSettingA() {
        this.runA0.setStartTime(new Date());
        Random random = new Random();
        int i = 0;
        while (i < 1000) {
            TupleMeasurement measurement = new TupleMeasurement((MetricSetDescription)this.measurementServiceCallA.getMeasuringType().getMetric(), new Measure[]{Measure.valueOf((int)i, this.timeUnit), Measure.valueOf((double)(random.nextDouble() * 10.0), this.timeUnit)});
            MeasurementsUtility.storeMeasurement((Measurement)this.measurementServiceCallA, (MeasuringValue)measurement);
            ++i;
        }
        LOGGER.info("Measurements for service call A generated.");
    }

    public void simulateExperimentRun() {
        this.prepareExperimentRunForSettingA();
        this.runExperimentForSettingA();
        LOGGER.info("Experiment run finished. Example data created.");
    }

    public String printStoredMeasurements(Repository repo, String experimentGroupUuid) {
        try {
            String result = "";
            for (ExperimentGroup group : repo.getExperimentGroups()) {
                if (!group.getId().equals(experimentGroupUuid)) continue;
                EList dataSeries = ((MeasurementRange)((Measurement)((ExperimentRun)((ExperimentSetting)group.getExperimentSettings().get(0)).getExperimentRuns().get(0)).getMeasurement().get(0)).getMeasurementRanges().get(0)).getRawMeasurements().getDataSeries();
                MeasurementsDao omdSeries1 = MeasurementsUtility.getMeasurementsDao((DataSeries)((DataSeries)dataSeries.get(0)));
                MeasurementsDao omdSeries2 = MeasurementsUtility.getMeasurementsDao((DataSeries)((DataSeries)dataSeries.get(1)));
                result = String.valueOf(result) + "Stored service call example data\n";
                result = String.valueOf(result) + "--------------------------------\n\n";
                MetricSetDescription md = (MetricSetDescription)((DataSeries)dataSeries.get(0)).getRawMeasurements().getMeasurementRange().getMeasurement().getMeasuringType().getMetric();
                result = String.valueOf(result) + ((MetricDescription)md.getSubsumedMetrics().get(0)).getName() + "\t" + ((MetricDescription)md.getSubsumedMetrics().get(1)).getName() + "\n";
                List list1 = omdSeries1.getMeasurements();
                List list2 = omdSeries2.getMeasurements();
                int pos = 0;
                while (pos < list1.size()) {
                    result = String.valueOf(result) + list1.get(pos) + "\t" + list2.get(pos) + "\n";
                    ++pos;
                }
                dataSeries = ((MeasurementRange)((Measurement)((ExperimentRun)((ExperimentSetting)group.getExperimentSettings().get(0)).getExperimentRuns().get(0)).getMeasurement().get(1)).getMeasurementRanges().get(0)).getRawMeasurements().getDataSeries();
                MeasurementsDao nmd = MeasurementsUtility.getMeasurementsDao((DataSeries)((DataSeries)dataSeries.get(0)));
                result = String.valueOf(result) + "Architecture Quality Estimation was: " + ((Identifier)((Measure)nmd.getMeasurements().get(0)).getValue()).getLiteral();
            }
            return result;
        }
        catch (NullPointerException npe) {
            LOGGER.log(Level.SEVERE, "Access to created example measurements failed. The data is either not created by the example code or there are store/load errors.");
            return "";
        }
    }

    public String printStoredMeasurements(Repository repo) {
        return this.printStoredMeasurements(repo, this.groupA.getId());
    }
}

