/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.repository.local.dao;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.quantity.Quantity;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.ExtendedIOUtil;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.dao.impl.AbstractMeasurementsDaoImpl;

abstract class FileAccessDao<V, Q extends Quantity>
extends AbstractMeasurementsDaoImpl<V, Q> {
    protected static final Logger LOGGER = Logger.getLogger(FileAccessDao.class.getCanonicalName());
    private static final String FILE_ACCESS_READ_ONLY = "r";
    private static final String FILE_ACCESS_READ_WRITE = "rw";
    protected File resourceFile = null;

    FileAccessDao() {
    }

    public synchronized void setResourceFile(File resourceFile) {
        if (this.resourceFile != null) {
            LOGGER.log(Level.SEVERE, "Setting the file resource is only allowed if there is no resource loaded.");
            throw new IllegalArgumentException();
        }
        this.resourceFile = resourceFile;
    }

    public synchronized void delete() throws DataNotAccessibleException {
        super.delete();
        if (this.resourceFile.exists() && !this.resourceFile.delete()) {
            String msg = "Could not delete file.";
            LOGGER.log(Level.WARNING, "Could not delete file.");
            throw new DataNotAccessibleException("Could not delete file.", null);
        }
        this.setDeleted(true);
    }

    public synchronized void deserialize(ExtendedDataInputStream input) throws DataNotAccessibleException {
        RandomAccessFile raf;
        super.deserialize(input);
        boolean oldOpenState = this.isOpen();
        if (oldOpenState) {
            this.close();
        }
        try {
            raf = new RandomAccessFile(this.resourceFile, FILE_ACCESS_READ_WRITE);
        }
        catch (FileNotFoundException e) {
            String msg = "Serialization error: File " + this.resourceFile.getAbsolutePath() + " on background storage could not be accessed.";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataNotAccessibleException(msg, (Throwable)e);
        }
        try {
            raf.seek(0L);
            byte[] b = ExtendedIOUtil.readByteArray((DataInput)input);
            raf.write(b);
            raf.setLength(b.length);
            raf.close();
        }
        catch (IOException ioe) {
            String msg = "Serialization error: Could not read from file " + this.resourceFile.getAbsolutePath() + " on background storage and store results in serialized stream.";
            LOGGER.log(Level.SEVERE, msg, ioe);
            throw new DataNotAccessibleException(msg, (Throwable)ioe);
        }
        if (oldOpenState) {
            this.open();
        }
    }

    public synchronized void serialize(ExtendedDataOutputStream output) throws DataNotAccessibleException {
        RandomAccessFile raf;
        super.serialize(output);
        boolean oldOpenState = this.isOpen();
        if (oldOpenState) {
            this.close();
        }
        try {
            raf = new RandomAccessFile(this.resourceFile, FILE_ACCESS_READ_ONLY);
        }
        catch (FileNotFoundException e) {
            String msg = "Serialization error: File " + this.resourceFile.getAbsolutePath() + " on background storage could not be accessed.";
            LOGGER.log(Level.SEVERE, msg, e);
            throw new DataNotAccessibleException(msg, (Throwable)e);
        }
        byte[] b = new byte[(int)this.resourceFile.length()];
        try {
            raf.seek(0L);
            raf.read(b);
            ExtendedIOUtil.writeByteArray((DataOutput)output, (byte[])b);
            raf.close();
        }
        catch (IOException ioe) {
            String msg = "Serialization error: Could not read from file " + this.resourceFile.getAbsolutePath() + " on background storage and store results in serialized stream.";
            LOGGER.log(Level.SEVERE, msg, ioe);
            throw new DataNotAccessibleException(msg, (Throwable)ioe);
        }
        if (oldOpenState) {
            this.open();
        }
    }
}

