/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.serializer;

import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.serializer.Serializer;

public class LongSerializer
implements Serializer<Long> {
    public Long[] deserialise(byte[] bytes) {
        Long[] longs = new Long[(int)((long)bytes.length / this.getElementLength())];
        int blockPos = 0;
        int j = 0;
        while (j < longs.length) {
            long l = 0L;
            int i = 7;
            while (i >= 0) {
                l <<= 8;
                l |= (long)(bytes[blockPos + i] < 0 ? 256 + bytes[blockPos + i] : bytes[blockPos + i]);
                --i;
            }
            blockPos += 8;
            longs[j] = l;
            ++j;
        }
        return longs;
    }

    @Override
    public long getElementLength() {
        return 8L;
    }

    @Override
    public byte[] serialise(Object[] objects, int count) {
        byte[] block = new byte[(int)((long)count * this.getElementLength())];
        int blockPos = 0;
        int j = 0;
        while (j < count) {
            long l = (Long)objects[j];
            int i = 0;
            while (i < 8) {
                block[blockPos++] = (byte)(l & 0xFFL);
                l >>= 8;
                ++i;
            }
            ++j;
        }
        return block;
    }
}

